/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl.binding;

import io.gravitee.rest.api.spec.converter.wsdl.WSDLUtils;
import io.gravitee.rest.api.spec.converter.wsdl.binding.AbstractBinding;
import io.gravitee.rest.api.spec.converter.wsdl.binding.BobyParts;
import io.gravitee.rest.api.spec.converter.wsdl.binding.HeaderDef;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;

public class SoapBinding
extends AbstractBinding {
    public static final String SOAP_ENVELOPE_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_ENVELOPE_PREFIXS = "soapenv";

    public SoapBinding(boolean rpc) {
        super(SOAP_ENVELOPE_NS, SOAP_ENVELOPE_PREFIXS, rpc);
    }

    @Override
    public boolean hasBodyElement(List<Object> elements) {
        Optional<SOAPBody> optBody = WSDLUtils.extractFirstElement(elements, SOAPBody.class);
        return optBody.isPresent();
    }

    @Override
    public BobyParts extractBodyParts(List<Object> elements) {
        Optional<SOAPBody> optBody = WSDLUtils.extractFirstElement(elements, SOAPBody.class);
        return new BobyParts(optBody.get().getParts() == null ? Collections.EMPTY_LIST : optBody.get().getParts(), optBody.get().getUse());
    }

    @Override
    public boolean hasHeadersElement(List<Object> elements) {
        Optional<SOAPHeader> optHeader = WSDLUtils.extractFirstElement(elements, SOAPHeader.class);
        return optHeader.isPresent();
    }

    @Override
    public List<HeaderDef> extractHeaderParts(List<Object> elements) {
        return WSDLUtils.extractAllElements(elements, SOAPHeader.class).map(header -> new HeaderDef(header.getMessage(), header.getUse(), header.getPart(), header.getRequired())).collect(Collectors.toList());
    }

    @Override
    public String getRpcNamespace(BindingOperation bindingOperation) {
        Optional<SOAPBody> optional = WSDLUtils.extractFirstElement(bindingOperation.getBindingInput().getExtensibilityElements(), SOAPBody.class);
        return optional.get().getNamespaceURI();
    }

    @Override
    public QName buildAttribute(String localPart) {
        return new QName(SOAP_ENVELOPE_NS, localPart, SOAP_ENVELOPE_PREFIXS);
    }
}

