/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.spec.converter.wsdl;

import io.gravitee.rest.api.spec.converter.wsdl.binding.Soap12Binding;
import io.gravitee.rest.api.spec.converter.wsdl.binding.SoapBinding;
import io.gravitee.rest.api.spec.converter.wsdl.binding.SoapVersion;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;

public class WSDLUtils {
    public static <T> Optional<T> extractFirstElement(List<Object> elements, Class<T> type) {
        return elements.stream().filter(elt -> type.isAssignableFrom(elt.getClass())).map(e -> e).findFirst();
    }

    public static <T> Stream<T> extractAllElements(List<Object> elements, Class<T> type) {
        return elements.stream().filter(elt -> type.isAssignableFrom(elt.getClass())).map(e -> e);
    }

    public static Optional<SoapVersion> detectSoapVersion(List<Object> elements) {
        Optional<SOAP12Binding> optSoap12 = WSDLUtils.extractFirstElement(elements, SOAP12Binding.class);
        if (optSoap12.isPresent()) {
            return Optional.of(new Soap12Binding("rpc".equalsIgnoreCase(optSoap12.get().getStyle())));
        }
        Optional<SOAPBinding> optSoap = WSDLUtils.extractFirstElement(elements, SOAPBinding.class);
        if (optSoap.isPresent()) {
            return Optional.of(new SoapBinding("rpc".equalsIgnoreCase(optSoap.get().getStyle())));
        }
        return Optional.empty();
    }

    public static String extractSOAPAddress(Port port) {
        Optional<SOAPAddress> optAddr = WSDLUtils.extractFirstElement(port.getExtensibilityElements(), SOAPAddress.class);
        Optional<SOAP12Address> optAddr12 = WSDLUtils.extractFirstElement(port.getExtensibilityElements(), SOAP12Address.class);
        Optional<HTTPAddress> optAddrHttp = WSDLUtils.extractFirstElement(port.getExtensibilityElements(), HTTPAddress.class);
        if (optAddr.isPresent()) {
            return optAddr.get().getLocationURI();
        }
        if (optAddr12.isPresent()) {
            return optAddr12.get().getLocationURI();
        }
        return optAddrHttp.map(addr -> addr.getLocationURI()).orElse("");
    }

    public static Optional<String> extractSOAPAction(BindingOperation operation) {
        Optional<SOAPOperation> optAddr = WSDLUtils.extractFirstElement(operation.getExtensibilityElements(), SOAPOperation.class);
        if (optAddr.isPresent()) {
            return optAddr.map(SOAPOperation::getSoapActionURI);
        }
        Optional<SOAP12Operation> optAddr12 = WSDLUtils.extractFirstElement(operation.getExtensibilityElements(), SOAP12Operation.class);
        return optAddr12.map(SOAP12Operation::getSoapActionURI);
    }

    public static String formatQName(QName qname) {
        if (qname.getPrefix() != null) {
            return qname.getPrefix() + ":" + qname.getLocalPart();
        }
        return qname.getLocalPart();
    }
}

