/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.definition.model.Origin;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PortalNotificationConfigUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortalNotificationConfigUpgrader.class);
    EnvironmentRepository environmentRepository;
    PortalNotificationConfigRepository portalNotificationConfigRepository;

    public PortalNotificationConfigUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy PortalNotificationConfigRepository portalNotificationConfigRepository) {
        this.environmentRepository = environmentRepository;
        this.portalNotificationConfigRepository = portalNotificationConfigRepository;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(this::applyUpgrade);
    }

    private boolean applyUpgrade() throws TechnicalException {
        Set environments = this.environmentRepository.findAll();
        List portalNotificationConfigs = this.portalNotificationConfigRepository.findAll().stream().filter(portalNotificationConfig -> portalNotificationConfig.getReferenceType().equals((Object)NotificationReferenceType.PORTAL) && portalNotificationConfig.getReferenceId().equals("DEFAULT")).flatMap(portalNotificationConfig -> this.migratePortalNotificationConfigToEnvironments(environments, (PortalNotificationConfig)portalNotificationConfig)).toList();
        log.info("Migrating portalNotificationConfig: {} for environments {}", (Object)portalNotificationConfigs.size(), (Object)environments);
        return true;
    }

    private Stream<PortalNotificationConfig> migratePortalNotificationConfigToEnvironments(Set<Environment> environments, PortalNotificationConfig portalNotificationConfig) {
        Stream<PortalNotificationConfig> stream = environments.stream().map(environment -> {
            PortalNotificationConfig portalNotificationConfigToCreate = this.duplicate((Environment)environment, portalNotificationConfig);
            try {
                return this.portalNotificationConfigRepository.create(portalNotificationConfigToCreate);
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException("Failed to duplicate portalNotificationConfig " + String.valueOf(portalNotificationConfig) + " to " + String.valueOf(environment), e);
            }
        });
        try {
            this.portalNotificationConfigRepository.delete(portalNotificationConfig);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Failed to delete portalNotificationConfig " + String.valueOf(portalNotificationConfig), e);
        }
        return stream;
    }

    private PortalNotificationConfig duplicate(Environment environment, PortalNotificationConfig portalNotificationConfig) {
        return PortalNotificationConfig.builder().referenceId(environment.getId()).referenceType(NotificationReferenceType.ENVIRONMENT).hooks(portalNotificationConfig.getHooks()).origin(portalNotificationConfig.getOrigin() != null ? portalNotificationConfig.getOrigin() : Origin.MANAGEMENT).user(portalNotificationConfig.getUser()).createdAt(portalNotificationConfig.getCreatedAt()).updatedAt(portalNotificationConfig.getUpdatedAt()).build();
    }

    public int getOrder() {
        return 200;
    }
}

