/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.organization.DeleteOrganizationCommand;
import io.gravitee.cockpit.api.command.v1.organization.DeleteOrganizationCommandPayload;
import io.gravitee.cockpit.api.command.v1.organization.DeleteOrganizationReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AccessPointRepository;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.ClusterRepository;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.CustomUserFieldsRepository;
import io.gravitee.repository.management.api.EntrypointRepository;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.api.IdentityProviderActivationRepository;
import io.gravitee.repository.management.api.IdentityProviderRepository;
import io.gravitee.repository.management.api.LicenseRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.api.NotificationTemplateRepository;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.api.PortalNotificationRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.api.TagRepository;
import io.gravitee.repository.management.api.TenantRepository;
import io.gravitee.repository.management.api.TokenRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.model.AccessPointReferenceType;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.CustomUserFieldReferenceType;
import io.gravitee.repository.management.model.EntrypointReferenceType;
import io.gravitee.repository.management.model.IdentityProviderActivationReferenceType;
import io.gravitee.repository.management.model.License;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.NotificationTemplateReferenceType;
import io.gravitee.repository.management.model.ParameterReferenceType;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.TagReferenceType;
import io.gravitee.repository.management.model.TenantReferenceType;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.TokenReferenceType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.cockpit.command.handler.DeleteEnvironmentCommandHandler;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.exceptions.OrganizationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DeleteOrganizationCommandHandler
implements CommandHandler<DeleteOrganizationCommand, DeleteOrganizationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteOrganizationCommandHandler.class);
    private final AccessPointCrudService accessPointService;
    private final AccessPointRepository accessPointRepository;
    private final AuditRepository auditRepository;
    private final CommandRepository commandRepository;
    private final CustomUserFieldsRepository customUserFieldsRepository;
    private final EntrypointRepository entrypointRepository;
    private final EnvironmentService environmentService;
    private final FlowRepository flowRepository;
    private final IdentityProviderActivationRepository identityProviderActivationRepository;
    private final IdentityProviderActivationService identityProviderActivationService;
    private final IdentityProviderRepository identityProviderRepository;
    private final LicenseRepository licenseRepository;
    private final MediaRepository mediaRepository;
    private final MembershipRepository membershipRepository;
    private final MetadataRepository metadataRepository;
    private final OrganizationService organizationService;
    private final NotificationTemplateRepository notificationTemplateRepository;
    private final ParameterRepository parameterRepository;
    private final PortalNotificationRepository portalNotificationRepository;
    private final RoleRepository roleRepository;
    private final SearchEngineService searchEngineService;
    private final TagRepository tagRepository;
    private final TenantRepository tenantRepository;
    private final TokenRepository tokenRepository;
    private final UserRepository userRepository;
    private final ClusterRepository clusterRepository;
    private final DeleteEnvironmentCommandHandler deleteEnvironmentCommandHandler;

    public DeleteOrganizationCommandHandler(@Lazy AccessPointRepository accessPointRepository, @Lazy AuditRepository auditRepository, @Lazy CommandRepository commandRepository, @Lazy CustomUserFieldsRepository customUserFieldsRepository, @Lazy EntrypointRepository entrypointRepository, @Lazy FlowRepository flowRepository, @Lazy IdentityProviderActivationRepository identityProviderActivationRepository, @Lazy IdentityProviderRepository identityProviderRepository, @Lazy LicenseRepository licenseRepository, @Lazy MediaRepository mediaRepository, @Lazy MembershipRepository membershipRepository, @Lazy MetadataRepository metadataRepository, @Lazy NotificationTemplateRepository notificationTemplateRepository, @Lazy ParameterRepository parameterRepository, @Lazy PortalNotificationRepository portalNotificationRepository, @Lazy RoleRepository roleRepository, @Lazy TagRepository tagRepository, @Lazy TenantRepository tenantRepository, @Lazy TokenRepository tokenRepository, @Lazy UserRepository userRepository, @Lazy ClusterRepository clusterRepository, AccessPointCrudService accessPointService, EnvironmentService environmentService, IdentityProviderActivationService identityProviderActivationService, OrganizationService organizationService, SearchEngineService searchEngineService, DeleteEnvironmentCommandHandler deleteEnvironmentCommandHandler) {
        this.accessPointRepository = accessPointRepository;
        this.accessPointService = accessPointService;
        this.auditRepository = auditRepository;
        this.commandRepository = commandRepository;
        this.customUserFieldsRepository = customUserFieldsRepository;
        this.entrypointRepository = entrypointRepository;
        this.environmentService = environmentService;
        this.flowRepository = flowRepository;
        this.identityProviderActivationRepository = identityProviderActivationRepository;
        this.identityProviderActivationService = identityProviderActivationService;
        this.identityProviderRepository = identityProviderRepository;
        this.licenseRepository = licenseRepository;
        this.mediaRepository = mediaRepository;
        this.membershipRepository = membershipRepository;
        this.metadataRepository = metadataRepository;
        this.notificationTemplateRepository = notificationTemplateRepository;
        this.organizationService = organizationService;
        this.parameterRepository = parameterRepository;
        this.portalNotificationRepository = portalNotificationRepository;
        this.roleRepository = roleRepository;
        this.searchEngineService = searchEngineService;
        this.tagRepository = tagRepository;
        this.tenantRepository = tenantRepository;
        this.tokenRepository = tokenRepository;
        this.userRepository = userRepository;
        this.clusterRepository = clusterRepository;
        this.deleteEnvironmentCommandHandler = deleteEnvironmentCommandHandler;
    }

    public String supportType() {
        return CockpitCommandType.DELETE_ORGANIZATION.name();
    }

    public Single<DeleteOrganizationReply> handle(DeleteOrganizationCommand command) {
        DeleteOrganizationCommandPayload payload = (DeleteOrganizationCommandPayload)command.getPayload();
        try {
            log.info("Delete organization with id [{}]", (Object)payload.cockpitId());
            OrganizationEntity organization = this.organizationService.findByCockpitId(payload.cockpitId());
            ExecutionContext executionContext = new ExecutionContext(organization);
            List<EnvironmentEntity> environments = this.environmentService.findByOrganization(organization.getId());
            for (EnvironmentEntity environment : environments) {
                this.deleteEnvironmentCommandHandler.processDeletionWorkflow(environment.getCockpitId(), payload.userId());
            }
            this.disableOrganization(executionContext);
            this.deleteOrganization(executionContext, organization);
            log.info("Organization [{}] with id [{}] has been deleted.", (Object)organization.getName(), (Object)organization.getId());
            return Single.just((Object)new DeleteOrganizationReply(command.getId()));
        }
        catch (OrganizationNotFoundException e) {
            log.warn("Organization with cockpitId [{}] has not been found.", (Object)payload.cockpitId());
            return Single.just((Object)new DeleteOrganizationReply(command.getId()));
        }
        catch (TechnicalException e) {
            String errorDetails = "Error occurred when deleting environments for organization id [%s].".formatted(payload.id());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new DeleteOrganizationReply(command.getId(), errorDetails));
        }
        catch (Exception e) {
            String errorDetails = "Error occurred when deleting organization with id [%s].".formatted(payload.id());
            log.error(errorDetails, (Throwable)e);
            return Single.just((Object)new DeleteOrganizationReply(command.getId(), errorDetails));
        }
    }

    private void disableOrganization(ExecutionContext executionContext) {
        this.accessPointService.deleteAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, executionContext.getOrganizationId());
        ExecutionContext context = new ExecutionContext(executionContext.getOrganizationId());
        this.identityProviderActivationService.removeAllIdpsFromTarget(context, new IdentityProviderActivationService.ActivationTarget(executionContext.getOrganizationId(), io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType.ORGANIZATION));
    }

    private void deleteOrganization(ExecutionContext executionContext, OrganizationEntity organization) throws TechnicalException {
        this.accessPointRepository.deleteByReferenceIdAndReferenceType(organization.getId(), AccessPointReferenceType.ORGANIZATION);
        this.flowRepository.deleteByReferenceIdAndReferenceType(organization.getId(), FlowReferenceType.ORGANIZATION);
        this.parameterRepository.deleteByReferenceIdAndReferenceType(organization.getId(), ParameterReferenceType.ORGANIZATION);
        this.customUserFieldsRepository.deleteByReferenceIdAndReferenceType(organization.getId(), CustomUserFieldReferenceType.ORGANIZATION);
        this.membershipRepository.deleteByReferenceIdAndReferenceType(executionContext.getOrganizationId(), MembershipReferenceType.ORGANIZATION);
        this.userRepository.deleteByOrganizationId(organization.getId()).forEach(userId -> {
            this.searchEngineService.delete(executionContext, (Indexable)UserEntity.builder().id(userId).build());
            try {
                this.portalNotificationRepository.deleteAll(userId);
                this.metadataRepository.deleteByReferenceIdAndReferenceType(userId, MetadataReferenceType.USER);
                this.tokenRepository.deleteByReferenceIdAndReferenceType(userId, TokenReferenceType.USER.name());
            }
            catch (TechnicalException e) {
                throw new TechnicalManagementException(e);
            }
        });
        this.tenantRepository.deleteByReferenceIdAndReferenceType(organization.getId(), TenantReferenceType.ORGANIZATION);
        this.roleRepository.deleteByReferenceIdAndReferenceType(organization.getId(), RoleReferenceType.ORGANIZATION);
        this.identityProviderRepository.deleteByOrganizationId(organization.getId());
        this.identityProviderActivationRepository.deleteByReferenceIdAndReferenceType(organization.getId(), IdentityProviderActivationReferenceType.ORGANIZATION);
        this.licenseRepository.delete(organization.getId(), License.ReferenceType.ORGANIZATION);
        this.tagRepository.deleteByReferenceIdAndReferenceType(organization.getId(), TagReferenceType.ORGANIZATION);
        this.commandRepository.deleteByOrganizationId(organization.getId());
        this.mediaRepository.deleteByOrganization(organization.getId());
        this.organizationService.delete(organization.getId());
        this.auditRepository.deleteByReferenceIdAndReferenceType(organization.getId(), Audit.AuditReferenceType.ORGANIZATION);
        this.notificationTemplateRepository.deleteByReferenceIdAndReferenceType(organization.getId(), NotificationTemplateReferenceType.ORGANIZATION);
        this.entrypointRepository.deleteByReferenceIdAndReferenceType(organization.getId(), EntrypointReferenceType.ORGANIZATION);
        this.clusterRepository.deleteByOrganizationId(organization.getId());
    }
}

