/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.json.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.gravitee.apim.core.json.JsonDeserializer;
import io.gravitee.apim.core.json.JsonProcessingException;
import io.gravitee.apim.infra.json.jackson.JsonMapperFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonDeserializer
implements JsonDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonJsonDeserializer.class);
    private final JsonMapper mapper;
    private final JsonMapper mapperNonStrict;

    public JacksonJsonDeserializer() {
        this(JsonMapperFactory.build());
    }

    public JacksonJsonDeserializer(JsonMapper mapper) {
        this.mapper = mapper;
        this.mapperNonStrict = mapper.copy();
        this.mapperNonStrict.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    @Override
    public <T> T deserialize(String json, Class<T> clazz) throws JsonProcessingException {
        return this.deserialize(this.mapper, json, clazz);
    }

    @Override
    public <T> T deserializeNonStrict(String json, Class<T> clazz) throws JsonProcessingException {
        return this.deserialize(this.mapperNonStrict, json, clazz);
    }

    private <T> T deserialize(JsonMapper mapper, String json, Class<T> clazz) throws JsonProcessingException {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (com.fasterxml.jackson.core.JsonProcessingException e) {
            log.debug("Fail to deserialize json: {}", (Object)json, (Object)e);
            throw new JsonProcessingException("Fail to deserialize json", e);
        }
    }
}

