/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.license.model.License;
import io.gravitee.apim.infra.adapter.LicenseAdapter;
import io.gravitee.repository.management.model.License;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class LicenseAdapterImpl
implements LicenseAdapter {
    @Override
    public License toModel(io.gravitee.repository.management.model.License license) {
        if (license == null) {
            return null;
        }
        License.LicenseBuilder license1 = License.builder();
        license1.referenceId(license.getReferenceId());
        license1.referenceType(this.referenceTypeToReferenceType(license.getReferenceType()));
        license1.license(license.getLicense());
        if (license.getCreatedAt() != null) {
            license1.createdAt(ZonedDateTime.ofInstant(license.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (license.getUpdatedAt() != null) {
            license1.updatedAt(ZonedDateTime.ofInstant(license.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return license1.build();
    }

    @Override
    public io.gravitee.repository.management.model.License toRepository(License license) {
        if (license == null) {
            return null;
        }
        License.LicenseBuilder license1 = io.gravitee.repository.management.model.License.builder();
        license1.referenceId(license.getReferenceId());
        license1.referenceType(this.referenceTypeToReferenceType1(license.getReferenceType()));
        license1.license(license.getLicense());
        if (license.getCreatedAt() != null) {
            license1.createdAt(Date.from(license.getCreatedAt().toInstant()));
        }
        if (license.getUpdatedAt() != null) {
            license1.updatedAt(Date.from(license.getUpdatedAt().toInstant()));
        }
        return license1.build();
    }

    protected License.ReferenceType referenceTypeToReferenceType(License.ReferenceType referenceType) {
        if (referenceType == null) {
            return null;
        }
        return switch (referenceType) {
            case License.ReferenceType.ORGANIZATION -> License.ReferenceType.ORGANIZATION;
            case License.ReferenceType.PLATFORM -> License.ReferenceType.PLATFORM;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(referenceType));
        };
    }

    protected License.ReferenceType referenceTypeToReferenceType1(License.ReferenceType referenceType) {
        if (referenceType == null) {
            return null;
        }
        return switch (referenceType) {
            case License.ReferenceType.ORGANIZATION -> License.ReferenceType.ORGANIZATION;
            case License.ReferenceType.PLATFORM -> License.ReferenceType.PLATFORM;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)referenceType));
        };
    }
}

