/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.sanitizer;

import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.owasp.html.AttributePolicy;
import org.owasp.html.CssSchema;
import org.owasp.html.HtmlChangeListener;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public final class HtmlSanitizer {
    private final Parser mdParser = Parser.builder((DataHolder)new MutableDataSet()).build();
    private final HtmlRenderer htmlRenderer = HtmlRenderer.builder((DataHolder)new MutableDataSet().set(HtmlRenderer.SUPPRESSED_LINKS, (Object)"")).build();
    private final PolicyFactory factory;

    public HtmlSanitizer(Environment environment) {
        this.factory = this.initPolicyFactory(environment);
    }

    public String sanitize(String content) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return this.factory.sanitize(content);
    }

    public <CTX> String sanitize(String content, HtmlChangeListener<CTX> listener, CTX context) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        return this.factory.sanitize(content, listener, context);
    }

    public SanitizeInfos isSafe(String content) {
        if (content == null || content.isEmpty()) {
            return new SanitizeInfos(true);
        }
        Document document = this.mdParser.parse(content);
        InvalidCommentVisitor visitor = new InvalidCommentVisitor();
        visitor.visit((Node)document);
        String toSanitize = this.htmlRenderer.render((Node)document);
        ArrayList sanitizedChanges = new ArrayList();
        HtmlChangeListener<List<String>> listener = new HtmlChangeListener<List<String>>(this){

            public void discardedTag(@Nullable List<String> context, String elementName) {
                context.add("Tag not allowed: " + elementName);
            }

            public void discardedAttributes(@Nullable List<String> context, String tagName, String ... attributeNames) {
                context.add("Attribute not allowed: [" + tagName + "]" + Arrays.toString(attributeNames));
            }
        };
        this.sanitize(toSanitize, listener, sanitizedChanges);
        return new SanitizeInfos(sanitizedChanges.isEmpty(), ((Object)sanitizedChanges).toString());
    }

    private PolicyFactory initPolicyFactory(Environment environment) {
        AttributePolicy IntegerAttributePolicy = (elementName, attributeName, value) -> {
            int n = value.length();
            if (n == 0) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                char ch = value.charAt(i);
                if (ch == '.') {
                    if (i == 0) {
                        return null;
                    }
                    return value.substring(0, i);
                }
                if ('0' <= ch && ch <= '9') continue;
                return null;
            }
            return value;
        };
        PolicyFactory htmlImagesSanitizer = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"data", "http", "https"}).allowElements(new String[]{"img"}).allowAttributes(new String[]{"alt", "title", "src"}).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "height", "width"}).matching(IntegerAttributePolicy).onElements(new String[]{"img"}).toFactory();
        PolicyFactory htmlCssSanitizer = new HtmlPolicyBuilder().allowStyling(CssSchema.union((CssSchema[])new CssSchema[]{CssSchema.DEFAULT, CssSchema.withProperties(Collections.singleton("float"))})).toFactory();
        PolicyFactory githubFlavouredMarkdownSanitizer = new HtmlPolicyBuilder().allowElements(new String[]{"summary", "details"}).toFactory();
        PolicyFactory policyFactory = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(new String[]{"a"}).allowAttributes(new String[]{"href", "title"}).onElements(new String[]{"a"}).toFactory()).and(htmlCssSanitizer).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowElements(new String[]{"pre", "hr"}).toFactory()).and(new HtmlPolicyBuilder().allowElements(new String[]{"ol"}).allowAttributes(new String[]{"start"}).onElements(new String[]{"ol"}).toFactory()).and(htmlImagesSanitizer).and(new HtmlPolicyBuilder().allowElements(new String[]{"code"}).allowAttributes(new String[]{"class"}).globally().toFactory()).and(githubFlavouredMarkdownSanitizer);
        PolicyFactory additionalElementsSanitizer = this.configureAdditionalElements(policyFactory, environment);
        if (additionalElementsSanitizer != null) {
            return policyFactory.and(additionalElementsSanitizer);
        }
        return policyFactory;
    }

    private PolicyFactory configureAdditionalElements(PolicyFactory factory, Environment environment) {
        Map<String, List<String>> allowedElements = this.getAllowedElementsFromProperties(environment);
        if (allowedElements.isEmpty()) {
            return null;
        }
        HtmlPolicyBuilder policyBuilder = new HtmlPolicyBuilder();
        for (Map.Entry<String, List<String>> entry : allowedElements.entrySet()) {
            String element = entry.getKey();
            List<String> attributes = entry.getValue();
            policyBuilder.allowElements(new String[]{element});
            for (String attribute : attributes) {
                policyBuilder.allowAttributes(new String[]{attribute}).onElements(new String[]{element});
            }
        }
        return policyBuilder.toFactory();
    }

    private Map<String, List<String>> getAllowedElementsFromProperties(Environment environment) {
        HashMap<String, List<String>> allowedElements = new HashMap<String, List<String>>();
        boolean found = true;
        int idx = 0;
        while (found) {
            String element = environment.getProperty("documentation.markdown.additional_allowed_elements[" + idx + "].element");
            if (element == null) {
                found = false;
            } else {
                List<String> attributes = this.readConfiguredAttributes(environment, idx);
                if (!attributes.isEmpty()) {
                    allowedElements.put(element, attributes);
                }
            }
            ++idx;
        }
        return allowedElements;
    }

    private List<String> readConfiguredAttributes(Environment environment, int idx) {
        ArrayList<String> attributes = new ArrayList<String>();
        boolean found = true;
        int attributeIdx = 0;
        while (found) {
            String attribute = environment.getProperty("documentation.markdown.additional_allowed_elements[" + idx + "].attributes[" + attributeIdx + "]");
            if (attribute == null) {
                found = false;
            } else {
                attributes.add(attribute);
            }
            ++attributeIdx;
        }
        return attributes;
    }

    public static class SanitizeInfos {
        boolean safe;
        String rejectedMessage;

        public SanitizeInfos(boolean safe) {
            this.safe = safe;
        }

        public SanitizeInfos(boolean safe, String rejectedMessage) {
            this.safe = safe;
            this.rejectedMessage = rejectedMessage;
        }

        @Generated
        public boolean isSafe() {
            return this.safe;
        }

        @Generated
        public String getRejectedMessage() {
            return this.rejectedMessage;
        }
    }

    static class InvalidCommentVisitor
    extends NodeVisitor {
        InvalidCommentVisitor() {
            super(new VisitHandler[]{new VisitHandler(HtmlCommentBlock.class, htmlBlock -> {
                String removedInvalidComments = htmlBlock.getChars().toString().replaceAll("<!-{2,3}>", "");
                htmlBlock.setChars(BasedSequence.of((CharSequence)removedInvalidComments));
            })});
        }
    }
}

