/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiCRDExportDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.IDExportStrategy;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.apim.infra.adapter.ApiCRDAdapter;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.v4.api.ExportApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.v4.ApiImportExportService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ApiCRDExportDomainServiceImpl
implements ApiCRDExportDomainService {
    private final ApiImportExportService exportService;
    private final ApiCrudService apiCrudService;
    private final UserCrudService userCrudService;
    private final GroupQueryService groupQueryService;

    @Override
    public ApiCRDSpec export(String apiId, IDExportStrategy idExport, AuditInfo auditInfo) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        ExportApiEntity exportEntity = this.exportService.exportApi(executionContext, apiId, null, Set.of());
        ApiCRDSpec spec = ApiCRDAdapter.INSTANCE.toCRDSpec(exportEntity, exportEntity.getApiEntity());
        if (spec.getMembers() != null) {
            this.setMembersSourceId(spec.getMembers());
            this.removePrimaryOwner(spec.getMembers());
        }
        if (spec.getGroups() != null) {
            spec.setGroups(this.getGroupNames(spec.getGroups()));
        }
        this.ensureCrossId(spec);
        this.applyIDExportStrategy(idExport, spec);
        return spec;
    }

    private void ensureCrossId(ApiCRDSpec spec) {
        if (StringUtils.isEmpty((CharSequence)spec.getCrossId())) {
            String crossId = UuidString.generateRandom();
            Api api = this.apiCrudService.get(spec.getId());
            api.setCrossId(crossId);
            this.apiCrudService.update(api);
            spec.setCrossId(crossId);
        }
    }

    private void setMembersSourceId(Set<MemberCRD> members) {
        Map membersById = members.stream().collect(Collectors.toMap(MemberCRD::getId, Function.identity()));
        Map usersById = this.userCrudService.findBaseUsersByIds(new ArrayList<String>(membersById.keySet())).stream().collect(Collectors.toMap(BaseUserEntity::getId, Function.identity()));
        membersById.forEach((id, member) -> {
            BaseUserEntity user = (BaseUserEntity)usersById.get(id);
            member.setSourceId(user.getSourceId());
            member.setSource(user.getSource());
            member.setId(null);
        });
    }

    private void removePrimaryOwner(Set<MemberCRD> members) {
        Iterator<MemberCRD> it = members.iterator();
        while (it.hasNext()) {
            MemberCRD member = it.next();
            if (!SystemRole.PRIMARY_OWNER.name().equals(member.getRole())) continue;
            it.remove();
            return;
        }
    }

    private Set<String> getGroupNames(Set<String> groups) {
        return this.groupQueryService.findByIds(groups).stream().map(Group::getName).collect(Collectors.toSet());
    }

    private void applyIDExportStrategy(IDExportStrategy idExport, ApiCRDSpec spec) {
        switch (idExport) {
            case GUID: {
                spec.setHrid(null);
                Optional.ofNullable(spec.getPlans()).orElse(Map.of()).forEach((k, plan) -> {
                    plan.setHrid(null);
                    plan.setGeneralConditionsHrid(null);
                });
                Optional.ofNullable(spec.getPages()).orElse(Map.of()).forEach((k, page) -> {
                    page.setHrid(null);
                    page.setParentHrid(null);
                });
                break;
            }
            case HRID: {
                spec.setId(null);
                spec.setCrossId(null);
                Optional.ofNullable(spec.getPlans()).orElse(Map.of()).forEach((k, plan) -> {
                    plan.setId(null);
                    plan.setCrossId(null);
                    plan.setGeneralConditions(null);
                });
                Optional.ofNullable(spec.getPages()).orElse(Map.of()).forEach((k, page) -> {
                    page.setId(null);
                    page.setCrossId(null);
                    page.setParentId(null);
                });
                break;
            }
            case NONE: {
                spec.setHrid(null);
                spec.setId(null);
                spec.setCrossId(null);
                Optional.ofNullable(spec.getPlans()).orElse(Map.of()).forEach((k, plan) -> {
                    plan.setHrid(null);
                    plan.setGeneralConditionsHrid(null);
                    plan.setId(null);
                    plan.setCrossId(null);
                    plan.setGeneralConditions(null);
                });
                Optional.ofNullable(spec.getPages()).orElse(Map.of()).forEach((k, page) -> {
                    page.setId(null);
                    page.setCrossId(null);
                    page.setParentId(null);
                    page.setHrid(null);
                    page.setParentHrid(null);
                });
                break;
            }
        }
    }

    @Generated
    public ApiCRDExportDomainServiceImpl(ApiImportExportService exportService, ApiCrudService apiCrudService, UserCrudService userCrudService, GroupQueryService groupQueryService) {
        this.exportService = exportService;
        this.apiCrudService = apiCrudService;
        this.userCrudService = userCrudService;
        this.groupQueryService = groupQueryService;
    }
}

