/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.category.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.category.query_service.CategoryQueryService;
import io.gravitee.apim.core.validation.Validator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

@DomainService
public class ValidateCategoryIdsDomainService
implements Validator<Input> {
    private static final String WARNING_FORMAT = "category [%s] is not defined in environment [%s]";
    private final CategoryQueryService categoryQueryService;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        Map<String, String> idOrKeyToId = this.mapToIds(input);
        Set<String> notFound = this.computeNotFound(idOrKeyToId, input.idOrKeys());
        return Validator.Result.ofBoth(input.sanitized(idOrKeyToId.values()), notFound.stream().map(idOrKey -> Validator.Error.warning(WARNING_FORMAT, idOrKey, input.environmentId)).toList());
    }

    private Map<String, String> mapToIds(Input input) {
        Set idOrKeys = Optional.ofNullable(input.idOrKeys).orElseGet(Set::of);
        HashMap<String, String> idOrKeyToId = new HashMap<String, String>();
        for (String idOrKey : idOrKeys) {
            this.categoryQueryService.findByIdOrKey(idOrKey, input.environmentId).ifPresent(category -> idOrKeyToId.put(idOrKey, category.getId()));
        }
        return idOrKeyToId;
    }

    private Set<String> computeNotFound(Map<String, String> found, Collection<String> given) {
        if (given == null) {
            return Set.of();
        }
        HashSet<String> notFound = new HashSet<String>(given);
        notFound.removeAll(found.keySet());
        return notFound;
    }

    @Generated
    public ValidateCategoryIdsDomainService(CategoryQueryService categoryQueryService) {
        this.categoryQueryService = categoryQueryService;
    }

    public record Input(String environmentId, Set<String> idOrKeys) implements Validator.Input
    {
        Input sanitized(Collection<String> ids) {
            return new Input(this.environmentId, new HashSet<String>(ids));
        }
    }
}

