/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.async_job.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.async_job.query_service.AsyncJobQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import java.util.Optional;
import lombok.Generated;

@UseCase
public class ListUserAsyncJobsUseCase {
    private final AsyncJobQueryService asyncJobQueryService;

    public Output execute(Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        Page<AsyncJob> page = this.asyncJobQueryService.listAsyncJobs(new AsyncJobQueryService.ListQuery(input.environmentId, Optional.of(input.initiatorId), input.type, input.status, input.sourceId), pageable);
        return new Output(page);
    }

    @Generated
    public ListUserAsyncJobsUseCase(AsyncJobQueryService asyncJobQueryService) {
        this.asyncJobQueryService = asyncJobQueryService;
    }

    public record Input(String environmentId, String initiatorId, Optional<AsyncJob.Type> type, Optional<AsyncJob.Status> status, Optional<String> sourceId, Optional<Pageable> pageable) {
        public Input {
            if (environmentId == null) {
                throw new IllegalArgumentException("Environment ID is required");
            }
            if (initiatorId == null) {
                throw new IllegalArgumentException("Initiator ID is required");
            }
        }

        public Input(String environmentId, String initiatorId) {
            this(environmentId, initiatorId, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Input(String environmentId, String initiatorId, AsyncJob.Type type) {
            this(environmentId, initiatorId, Optional.ofNullable(type), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Input(String environmentId, String initiatorId, AsyncJob.Status status) {
            this(environmentId, initiatorId, Optional.empty(), Optional.ofNullable(status), Optional.empty(), Optional.empty());
        }

        public Input(String environmentId, String initiatorId, AsyncJob.Type type, AsyncJob.Status status) {
            this(environmentId, initiatorId, Optional.ofNullable(type), Optional.ofNullable(status), Optional.empty(), Optional.empty());
        }
    }

    public record Output(Page<AsyncJob> jobs) {
    }
}

