/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case.members;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.membership.domain_service.MembershipDomainService;
import io.gravitee.apim.core.membership.model.AddMember;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import lombok.Generated;

@UseCase
public class AddClusterMemberUseCase {
    private final MembershipDomainService membershipDomainService;

    public Output execute(Input input) {
        this.validateMembership(input.addMember);
        this.membershipDomainService.createNewMembership(GraviteeContext.getExecutionContext(), MembershipReferenceType.CLUSTER, input.clusterId, input.addMember.getUserId(), input.addMember.getExternalReference(), input.addMember.getRoleName());
        return new Output();
    }

    private void validateMembership(AddMember addMember) {
        if (SystemRole.PRIMARY_OWNER.name().equals(addMember.getRoleName())) {
            throw new SinglePrimaryOwnerException(RoleScope.CLUSTER);
        }
    }

    @Generated
    public AddClusterMemberUseCase(MembershipDomainService membershipDomainService) {
        this.membershipDomainService = membershipDomainService;
    }

    public record Input(AuditInfo audit, AddMember addMember, String clusterId) {
    }

    public record Output() {
    }
}

