/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PageAuditEvent;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.crud_service.PageRevisionCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.search.model.IndexablePage;
import java.time.ZoneId;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class CreateApiDocumentationDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateApiDocumentationDomainService.class);
    private final PageCrudService pageCrudService;
    private final PageRevisionCrudService pageRevisionCrudService;
    private final AuditDomainService auditDomainService;
    private final Indexer indexer;

    public Page createPage(Page page, AuditInfo auditInfo) {
        Page createdPage = this.pageCrudService.createDocumentationPage(page);
        if (page.isSwaggerOrMarkdown()) {
            this.pageRevisionCrudService.create(createdPage);
            this.indexer.index(new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId()), new IndexablePage(createdPage));
        }
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().apiId(page.getReferenceId()).event(PageAuditEvent.PAGE_CREATED).createdAt(page.getCreatedAt().toInstant().atZone(ZoneId.of("UTC"))).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).actor(auditInfo.actor()).properties(Map.of(AuditProperties.PAGE, page.getId())).oldValue(null).newValue(page).build());
        return createdPage;
    }

    @Generated
    public CreateApiDocumentationDomainService(PageCrudService pageCrudService, PageRevisionCrudService pageRevisionCrudService, AuditDomainService auditDomainService, Indexer indexer) {
        this.pageCrudService = pageCrudService;
        this.pageRevisionCrudService = pageRevisionCrudService;
        this.auditDomainService = auditDomainService;
        this.indexer = indexer;
    }
}

