/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.domain_service.ApiAnalyticsSpecification;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.rest.api.model.v4.analytics.RequestsCount;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchRequestsCountByEventAnalyticsUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchRequestsCountByEventAnalyticsUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiCrudService apiCrudService;

    public Output execute(ExecutionContext executionContext, Input input) {
        ApiAnalyticsSpecification.forRequestsCountAnalytics().throwIfNotSatisfied(this.apiCrudService.get(input.apiId()), executionContext, input.from(), input.to());
        AnalyticsQueryService.CountQuery countQuery = new AnalyticsQueryService.CountQuery(AnalyticsQueryService.SearchTermId.forApi(input.apiId), Instant.ofEpochMilli(input.from()), Instant.ofEpochMilli(input.to()), input.query());
        RequestsCount result = this.analyticsQueryService.searchRequestsCountByEvent(executionContext, countQuery).orElse(RequestsCount.builder().total(Long.valueOf(0L)).countsByEntrypoint(Map.of()).build());
        return new Output(result);
    }

    @Generated
    public SearchRequestsCountByEventAnalyticsUseCase(AnalyticsQueryService analyticsQueryService, ApiCrudService apiCrudService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, long from, long to, Optional<String> query) {
    }

    public record Output(RequestsCount result) {
    }
}

