/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.membership;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.infra.adapter.RoleAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class RoleQueryServiceImpl
implements RoleQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleQueryServiceImpl.class);
    private final RoleRepository roleRepository;

    public RoleQueryServiceImpl(@Lazy RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    @Override
    public Optional<Role> findApiRole(String name, ReferenceContext referenceContext) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.API, name, referenceContext.getReferenceId(), RoleReferenceType.valueOf((String)referenceContext.getReferenceType().name())).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find api role", e);
        }
    }

    @Override
    public Optional<Role> findByScopeAndName(Role.Scope scope, String name, String organizationId) {
        try {
            log.debug("Find Roles by scope and name");
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.valueOf((String)scope.name()), name, organizationId, RoleReferenceType.ORGANIZATION).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by scope", ex);
        }
    }

    @Override
    public Optional<Role> findApplicationRole(String name, ReferenceContext referenceContext) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.APPLICATION, name, referenceContext.getReferenceId(), RoleReferenceType.valueOf((String)referenceContext.getReferenceType().name())).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find application role", e);
        }
    }

    @Override
    public Optional<Role> findIntegrationRole(String name, ReferenceContext referenceContext) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.INTEGRATION, name, referenceContext.getReferenceId(), RoleReferenceType.valueOf((String)referenceContext.getReferenceType().name())).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find integration role", e);
        }
    }

    @Override
    public Optional<Role> findByScopeAndNameAndOrganizationId(Role.Scope scope, String name, String organizationId) {
        try {
            return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.valueOf((String)scope.name()), name, organizationId, RoleReferenceType.ORGANIZATION).map(RoleAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to find " + scope.name() + " role", e);
        }
    }

    @Override
    public Set<Role> findByIds(Set<String> ids) {
        if (Objects.isNull(ids) || ids.isEmpty()) {
            return Set.of();
        }
        try {
            return this.roleRepository.findAllByIdIn(ids).stream().map(RoleAdapter.INSTANCE::toEntity).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurred while trying to find role by list of ids", e);
        }
    }
}

