/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.domain_service.AnalyticsMetadataProvider;
import io.gravitee.apim.core.analytics.domain_service.ApiAnalyticsSpecification;
import io.gravitee.apim.core.analytics.model.Aggregation;
import io.gravitee.apim.core.analytics.model.EventAnalytics;
import io.gravitee.apim.core.analytics.model.HistogramAnalytics;
import io.gravitee.apim.core.analytics.model.Term;
import io.gravitee.apim.core.analytics.model.Timestamp;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchHistogramAnalyticsUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchHistogramAnalyticsUseCase.class);
    private final ApiCrudService apiCrudService;
    private final AnalyticsQueryService analyticsQueryService;
    private final List<AnalyticsMetadataProvider> metadataProviders;

    public Output execute(ExecutionContext executionContext, Input input) {
        Api api = this.apiCrudService.get(input.api);
        ApiAnalyticsSpecification.forSearchHistogramAnalytics().throwIfNotSatisfied(api, executionContext, input.from(), input.to());
        if (api.getType() == ApiType.NATIVE) {
            return this.executeV4NativeAPICase(executionContext, input);
        }
        return this.executeV4APICase(executionContext, input);
    }

    private Output executeV4APICase(ExecutionContext executionContext, Input input) {
        AnalyticsQueryService.HistogramQuery histogramQuery = new AnalyticsQueryService.HistogramQuery(AnalyticsQueryService.SearchTermId.forApi(input.api), Instant.ofEpochMilli(input.from()), Instant.ofEpochMilli(input.to()), Duration.ofMillis(input.interval()), input.aggregations(), input.query(), null);
        List<HistogramAnalytics.Bucket> result = this.analyticsQueryService.searchHistogramAnalytics(executionContext, histogramQuery).map(HistogramAnalytics::buckets).orElse(List.of());
        HashMap<String, Map<String, Map<String, String>>> metadata = new HashMap<String, Map<String, Map<String, String>>>();
        List<HistogramAnalytics.CountBucket> countBuckets = result.stream().filter(bucket -> bucket instanceof HistogramAnalytics.CountBucket).map(bucket -> (HistogramAnalytics.CountBucket)bucket).toList();
        for (HistogramAnalytics.CountBucket countBucket : countBuckets) {
            Optional<AnalyticsMetadataProvider> providerOpt = this.metadataProviders.stream().filter(p -> p.appliesTo(AnalyticsMetadataProvider.Field.of(countBucket.getField()))).findFirst();
            if (providerOpt.isPresent()) {
                AnalyticsMetadataProvider provider = providerOpt.get();
                ArrayList<String> keys = new ArrayList<String>(countBucket.getCounts().keySet());
                Map<String, Map<String, String>> bucketMetadata = provider.provide(keys, executionContext.getEnvironmentId());
                metadata.put(countBucket.getName(), bucketMetadata);
                continue;
            }
            metadata.put(countBucket.getName(), Collections.emptyMap());
        }
        return new Output(new Timestamp(Instant.ofEpochMilli(input.from()), Instant.ofEpochMilli(input.to()), Duration.ofMillis(input.interval())), result, metadata);
    }

    private Output executeV4NativeAPICase(ExecutionContext executionContext, Input input) {
        Instant from = Instant.ofEpochMilli(input.from());
        Instant to = Instant.ofEpochMilli(input.to());
        AnalyticsQueryService.HistogramQuery histogramQuery = new AnalyticsQueryService.HistogramQuery(AnalyticsQueryService.SearchTermId.forApi(input.api), from, to, Duration.ofMillis(input.interval()), input.aggregations(), input.query(), input.terms() != null && input.terms().isPresent() ? input.terms().get() : List.of());
        Optional<EventAnalytics> eventAnalytics = this.analyticsQueryService.searchEventAnalytics(executionContext, histogramQuery);
        ArrayList<HistogramAnalytics.Bucket> buckets = new ArrayList<HistogramAnalytics.Bucket>();
        Timestamp timestamp = new Timestamp(from, to, Duration.ofMillis(input.interval()));
        eventAnalytics.ifPresent(analytics -> analytics.values().forEach((key, values) -> {
            HistogramAnalytics.MetricBucket bucket = new HistogramAnalytics.MetricBucket((String)key, (String)key, (List<Long>)values);
            buckets.add(bucket);
        }));
        return new Output(timestamp, buckets, Collections.emptyMap());
    }

    @Generated
    public SearchHistogramAnalyticsUseCase(ApiCrudService apiCrudService, AnalyticsQueryService analyticsQueryService, List<AnalyticsMetadataProvider> metadataProviders) {
        this.apiCrudService = apiCrudService;
        this.analyticsQueryService = analyticsQueryService;
        this.metadataProviders = metadataProviders;
    }

    public record Input(String api, long from, long to, long interval, List<Aggregation> aggregations, Optional<String> query, Optional<List<Term>> terms) {
    }

    public record Output(Timestamp timestamp, List<HistogramAnalytics.Bucket> values, Map<String, Map<String, Map<String, String>>> metadata) {
    }
}

