/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.PlanRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PlanHRIDUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanHRIDUpgrader.class);
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;

    public boolean upgrade() {
        try {
            this.planRepository.findAll().forEach(plan -> {
                plan.setHrid(plan.getId());
                try {
                    this.planRepository.update(plan);
                }
                catch (TechnicalException e) {
                    log.error("Unable to set HRID for Plan {}", (Object)plan.getId(), (Object)e);
                    throw new RuntimeException(e);
                }
            });
            return true;
        }
        catch (TechnicalException e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
    }

    public int getOrder() {
        return 709;
    }
}

