/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ClusterRolesUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterRolesUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public ClusterRolesUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    public boolean upgrade() throws UpgraderException {
        return this.wrapException(() -> {
            this.organizationRepository.findAll().forEach(organization -> {
                ExecutionContext executionContext = new ExecutionContext((Organization)organization);
                this.updateEnvironmentApiPublisher(executionContext, organization.getId());
                this.initializeClusterRoles(executionContext);
                this.roleService.createOrUpdateSystemRoles(executionContext, executionContext.getOrganizationId());
            });
            return true;
        });
    }

    private void updateEnvironmentApiPublisher(ExecutionContext executionContext, String organizationId) {
        Optional<RoleEntity> environmentApiPublisher = this.roleService.findByScopeAndName(RoleScope.ENVIRONMENT, "API_PUBLISHER", organizationId);
        if (environmentApiPublisher.isPresent()) {
            UpdateRoleEntity updateRole = UpdateRoleEntity.from((RoleEntity)environmentApiPublisher.get());
            updateRole.getPermissions().put(EnvironmentPermission.CLUSTER.getName(), new char[]{RolePermissionAction.READ.getId()});
            this.roleService.update(executionContext, updateRole);
        }
    }

    private void initializeClusterRoles(ExecutionContext executionContext) {
        if (this.shouldCreateClusterUserRole(executionContext)) {
            log.info("     - <CLUSTER> USER");
            this.roleService.create(executionContext, DefaultRoleEntityDefinition.CLUSTER_ROLE_USER);
        }
        if (this.shouldCreateClusterOwnerRole(executionContext)) {
            log.info("     - <CLUSTER> OWNER");
            this.roleService.create(executionContext, DefaultRoleEntityDefinition.CLUSTER_ROLE_OWNER);
        }
    }

    private boolean shouldCreateClusterUserRole(ExecutionContext executionContext) {
        return this.roleService.findByScopeAndName(RoleScope.CLUSTER, DefaultRoleEntityDefinition.CLUSTER_ROLE_USER.getName(), executionContext.getOrganizationId()).isEmpty();
    }

    private boolean shouldCreateClusterOwnerRole(ExecutionContext executionContext) {
        return this.roleService.findByScopeAndName(RoleScope.CLUSTER, DefaultRoleEntityDefinition.CLUSTER_ROLE_OWNER.getName(), executionContext.getOrganizationId()).isEmpty();
    }

    public int getOrder() {
        return 900;
    }
}

