/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.application.registration.client.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.configuration.application.registration.KeyStoreEntity;
import io.gravitee.rest.api.model.configuration.application.registration.TrustStoreEntity;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.DynamicClientRegistrationException;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.common.SecureHttpClientUtils;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.token.InitialAccessTokenProvider;
import io.gravitee.rest.api.service.impl.configuration.application.registration.client.token.TokenResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsInitialAccessTokenProvider
implements InitialAccessTokenProvider {
    private final Logger logger = LoggerFactory.getLogger(ClientCredentialsInitialAccessTokenProvider.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final String clientId;
    private final String clientSecret;
    private final List<String> scopes;

    public ClientCredentialsInitialAccessTokenProvider(String clientId, String clientSecret) {
        this(clientId, clientSecret, Collections.emptyList());
    }

    public ClientCredentialsInitialAccessTokenProvider(String clientId, String clientSecret, List<String> scopes) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = scopes;
    }

    @Override
    public String get(Map<String, String> attributes, TrustStoreEntity trustStore, KeyStoreEntity keyStore) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String tokenEndpoint = attributes.get("token_endpoint");
        HttpPost tokenRequest = new HttpPost(tokenEndpoint);
        ArrayList<BasicNameValuePair> tokenRequestParams = new ArrayList<BasicNameValuePair>();
        tokenRequestParams.add(new BasicNameValuePair("grant_type", "client_credentials"));
        if (this.scopes != null && !this.scopes.isEmpty()) {
            tokenRequestParams.add(new BasicNameValuePair("scope", String.join((CharSequence)" ", this.scopes)));
        }
        tokenRequest.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes()));
        tokenRequest.setHeader("Accept", "application/json");
        try {
            tokenRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(tokenRequestParams));
            httpClient = SecureHttpClientUtils.createHttpClient(trustStore, keyStore);
            String string = (String)httpClient.execute((HttpUriRequest)tokenRequest, response -> {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        TokenResponse token = (TokenResponse)this.mapper.readValue(EntityUtils.toString((HttpEntity)entity), TokenResponse.class);
                        return token.getAccessToken();
                    }
                    throw new DynamicClientRegistrationException("Token response does not contain any body");
                }
                String responsePayload = EntityUtils.toString((HttpEntity)response.getEntity());
                if (responsePayload != null && !responsePayload.isEmpty()) {
                    try {
                        JsonNode node = this.mapper.readTree(responsePayload);
                        String error = node.path("error").asText();
                        String description = node.path("error_description").asText();
                        this.logger.error("Unexpected response from OIDC Token endpoint: error[{}] description[{}]", (Object)error, (Object)description);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Token endpoint: error[" + error + "] description[" + description + "]");
                    }
                    catch (JsonProcessingException ex) {
                        this.logger.error("Unexpected response from OIDC Token endpoint: status[{}] message[{}]", (Object)status, (Object)responsePayload);
                        throw new DynamicClientRegistrationException("Unexpected response from OIDC Token endpoint: status[" + status + "] message[" + responsePayload + "]");
                    }
                }
                this.logger.error("Unexpected response from OIDC Token endpoint: status[{}]", (Object)status);
                throw new DynamicClientRegistrationException("Unexpected response from OIDC Token endpoint: status[" + status + "]");
            });
            return string;
        }
        catch (Exception ex) {
            this.logger.error("Unexpected error while generating an access_token: " + ex.getMessage(), (Throwable)ex);
            throw new DynamicClientRegistrationException("Unexpected error while generating an access_token: " + ex.getMessage(), ex);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                this.logger.error("Unable to close HTTP client", (Throwable)e);
            }
        }
    }
}

