/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CustomUserFieldsRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.CustomUserField;
import io.gravitee.repository.management.model.CustomUserFieldReferenceType;
import io.gravitee.repository.management.model.MetadataFormat;
import io.gravitee.rest.api.model.CustomUserFieldEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CustomUserFieldService;
import io.gravitee.rest.api.service.UserMetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.CustomUserFieldAlreadyExistException;
import io.gravitee.rest.api.service.exceptions.CustomUserFieldNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.sanitizer.CustomFieldSanitizer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CustomUserFieldsServiceImpl
extends TransactionalService
implements CustomUserFieldService {
    private final Logger LOGGER = LoggerFactory.getLogger(CustomUserFieldsServiceImpl.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Lazy
    @Autowired
    private CustomUserFieldsRepository customUserFieldsRepository;
    @Lazy
    @Autowired
    private MetadataRepository metadataRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private UserMetadataService userMetadataService;

    @Override
    public CustomUserFieldEntity create(ExecutionContext executionContext, CustomUserFieldEntity newFieldEntity) {
        try {
            String refId = executionContext.getOrganizationId();
            CustomUserFieldReferenceType refType = CustomUserFieldReferenceType.ORGANIZATION;
            this.LOGGER.debug("Create custom user field [key={}, refId={}]", (Object)newFieldEntity.getKey(), (Object)refId);
            Optional existingRecord = this.customUserFieldsRepository.findById(CustomFieldSanitizer.formatKeyValue(newFieldEntity.getKey()), refId, refType);
            if (existingRecord.isPresent()) {
                throw new CustomUserFieldAlreadyExistException(newFieldEntity.getKey());
            }
            CustomUserField fieldToCreate = this.map(newFieldEntity);
            fieldToCreate.setReferenceId(refId);
            fieldToCreate.setReferenceType(refType);
            Date now = new Date();
            fieldToCreate.setCreatedAt(now);
            fieldToCreate.setUpdatedAt(now);
            CustomUserField recorded = this.customUserFieldsRepository.create(fieldToCreate);
            this.createAuditLog(executionContext, (Audit.AuditEvent)CustomUserField.AuditEvent.CUSTOM_USER_FIELD_CREATED, now, null, recorded);
            return this.map(recorded);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to create CustomUserField", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to create CustomUserField", e);
        }
    }

    @Override
    public CustomUserFieldEntity update(ExecutionContext executionContext, CustomUserFieldEntity updateFieldEntity) {
        try {
            String refId = executionContext.getOrganizationId();
            CustomUserFieldReferenceType refType = CustomUserFieldReferenceType.ORGANIZATION;
            this.LOGGER.debug("Update custom user field [key={}, refId={}]", (Object)updateFieldEntity.getKey(), (Object)refId);
            Optional existingRecord = this.customUserFieldsRepository.findById(CustomFieldSanitizer.formatKeyValue(updateFieldEntity.getKey()), refId, refType);
            if (existingRecord.isPresent()) {
                CustomUserField fieldToUpdate = this.map(updateFieldEntity);
                fieldToUpdate.setKey(((CustomUserField)existingRecord.get()).getKey());
                fieldToUpdate.setReferenceId(((CustomUserField)existingRecord.get()).getReferenceId());
                fieldToUpdate.setReferenceType(((CustomUserField)existingRecord.get()).getReferenceType());
                fieldToUpdate.setCreatedAt(((CustomUserField)existingRecord.get()).getCreatedAt());
                Date updatedAt = new Date();
                fieldToUpdate.setUpdatedAt(updatedAt);
                CustomUserField updatedField = this.customUserFieldsRepository.update(fieldToUpdate);
                this.createAuditLog(executionContext, (Audit.AuditEvent)CustomUserField.AuditEvent.CUSTOM_USER_FIELD_UPDATED, updatedAt, (CustomUserField)existingRecord.get(), updatedField);
                return this.map(updatedField);
            }
            throw new CustomUserFieldNotFoundException(updateFieldEntity.getKey());
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to update CustomUserField", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to update CustomUserField", e);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String key) {
        try {
            String refId = executionContext.getOrganizationId();
            CustomUserFieldReferenceType refType = CustomUserFieldReferenceType.ORGANIZATION;
            this.LOGGER.debug("Delete custom user field [key={}, refId={}]", (Object)key, (Object)refId);
            Optional existingRecord = this.customUserFieldsRepository.findById(CustomFieldSanitizer.formatKeyValue(key), refId, refType);
            if (existingRecord.isPresent()) {
                this.customUserFieldsRepository.delete(CustomFieldSanitizer.formatKeyValue(key), refId, refType);
                this.createAuditLog(executionContext, (Audit.AuditEvent)CustomUserField.AuditEvent.CUSTOM_USER_FIELD_DELETED, new Date(), (CustomUserField)existingRecord.get(), null);
                this.userMetadataService.deleteAllByCustomFieldId(executionContext, ((CustomUserField)existingRecord.get()).getKey(), ((CustomUserField)existingRecord.get()).getReferenceId(), ((CustomUserField)existingRecord.get()).getReferenceType());
            }
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to create CustomUserField", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to create CustomUserField", e);
        }
    }

    @Override
    public List<CustomUserFieldEntity> listAllFields(ExecutionContext executionContext) {
        try {
            String refId = executionContext.getOrganizationId();
            CustomUserFieldReferenceType refType = CustomUserFieldReferenceType.ORGANIZATION;
            this.LOGGER.debug("List all custom user fields [refId={}/refType={}]", (Object)refId, (Object)refType);
            List records = this.customUserFieldsRepository.findByReferenceIdAndReferenceType(refId, refType);
            return records.stream().map(this::map).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to list all CustomUserField", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to list all CustomUserField", e);
        }
    }

    private void createAuditLog(ExecutionContext executionContext, Audit.AuditEvent event, Date createdAt, CustomUserField oldValue, CustomUserField newValue) {
        CustomUserFieldReferenceType type;
        String key = oldValue != null ? oldValue.getKey() : newValue.getKey();
        CustomUserFieldReferenceType customUserFieldReferenceType = type = oldValue != null ? oldValue.getReferenceType() : newValue.getReferenceType();
        if (type == CustomUserFieldReferenceType.ORGANIZATION) {
            this.auditService.createOrganizationAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.USER_FIELD, key)).event(event).createdAt(createdAt).oldValue(oldValue).newValue(newValue).build());
        } else if (type == CustomUserFieldReferenceType.ENVIRONMENT) {
            this.auditService.createAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.USER_FIELD, key)).event(event).createdAt(createdAt).oldValue(oldValue).newValue(newValue).build());
        }
    }

    private CustomUserField map(CustomUserFieldEntity entity) {
        CustomUserField result = new CustomUserField();
        result.setKey(CustomFieldSanitizer.formatKeyValue(entity.getKey()));
        result.setLabel(entity.getLabel());
        result.setRequired(entity.isRequired());
        result.setFormat(MetadataFormat.STRING);
        if (entity.getValues() != null) {
            result.setValues(entity.getValues().stream().distinct().collect(Collectors.toList()));
        }
        return result;
    }

    private CustomUserFieldEntity map(CustomUserField record) {
        CustomUserFieldEntity result = new CustomUserFieldEntity();
        result.setKey(CustomFieldSanitizer.formatKeyValue(record.getKey()));
        result.setLabel(record.getLabel());
        result.setRequired(record.isRequired());
        if (record.getValues() != null) {
            switch (record.getFormat()) {
                case STRING: {
                    result.setValues(record.getValues());
                    break;
                }
                default: {
                    throw new TechnicalManagementException("Unable to read values of CustomUserField, format not supported");
                }
            }
        }
        return result;
    }
}

