/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.targettoken.DeleteTargetTokenCommand;
import io.gravitee.cockpit.api.command.v1.targettoken.DeleteTargetTokenCommandPayload;
import io.gravitee.cockpit.api.command.v1.targettoken.DeleteTargetTokenReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeleteTargetTokenCommandHandler
implements CommandHandler<DeleteTargetTokenCommand, DeleteTargetTokenReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteTargetTokenCommandHandler.class);
    private final UserService userService;

    public String supportType() {
        return CockpitCommandType.DELETE_TARGET_TOKEN.name();
    }

    public Single<DeleteTargetTokenReply> handle(DeleteTargetTokenCommand command) {
        DeleteTargetTokenCommandPayload payload = (DeleteTargetTokenCommandPayload)command.getPayload();
        ExecutionContext context = new ExecutionContext(payload.organizationId(), payload.environmentId());
        try {
            UserEntity userEntity = this.userService.findBySource(payload.organizationId(), "cloud-token", payload.id(), false);
            this.userService.delete(context, userEntity.getId());
            log.info("User with id [{}] has been deleted.", (Object)userEntity.getId());
        }
        catch (UserNotFoundException e) {
            log.info("User with id [{}] has not been found.", (Object)payload.id());
        }
        catch (Exception e) {
            log.error("Error occurred while deleting target token for user with id [{}].", (Object)payload.id(), (Object)e);
            return Single.just((Object)new DeleteTargetTokenReply(command.getId(), CommandStatus.ERROR));
        }
        return Single.just((Object)new DeleteTargetTokenReply(command.getId(), CommandStatus.SUCCEEDED));
    }

    @Generated
    public DeleteTargetTokenCommandHandler(UserService userService) {
        this.userService = userService;
    }
}

