/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommandPayload;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReplyPayload;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PromoteApiOperationHandler
implements BridgeOperationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PromoteApiOperationHandler.class);
    private final PromotionService promotionService;
    private final InstallationService installationService;
    private final ObjectMapper objectMapper;

    @Override
    public boolean canHandle(String bridgeOperation) {
        return Objects.equals(BridgeOperation.PROMOTE_API.name(), bridgeOperation);
    }

    @Override
    public Single<BridgeReply> handle(BridgeCommand bridgeCommand) {
        PromotionEntity promotionEntity;
        BridgeCommandPayload commandPayload = (BridgeCommandPayload)bridgeCommand.getPayload();
        try {
            promotionEntity = (PromotionEntity)this.objectMapper.readValue(commandPayload.content(), PromotionEntity.class);
        }
        catch (JsonProcessingException e) {
            String errorDetails = "Problem while deserializing promotion request for environment [%s]".formatted(commandPayload.environmentId());
            log.warn(errorDetails, (Throwable)e);
            return Single.just((Object)new BridgeReply(bridgeCommand.getId(), errorDetails));
        }
        promotionEntity.setStatus(PromotionEntityStatus.TO_BE_VALIDATED);
        return Single.fromCallable(() -> this.promotionService.createOrUpdate(promotionEntity)).subscribeOn(Schedulers.io()).map(promotion -> {
            try {
                return new BridgeReply(bridgeCommand.getId(), new BridgeReplyPayload(true, List.of(BridgeReplyPayload.BridgeReplyContent.builder().environmentId(commandPayload.target().environmentId()).organizationId(commandPayload.organizationId()).installationId(this.installationService.get().getId()).content(this.objectMapper.writeValueAsString(promotion)).build())));
            }
            catch (JsonProcessingException e) {
                String errorDetails = "Problem while serializing promotion request for environment [%s]".formatted(((BridgeCommandPayload)bridgeCommand.getPayload()).environmentId());
                log.warn(errorDetails);
                return new BridgeReply(bridgeCommand.getId(), errorDetails);
            }
        }).onErrorReturn(throwable -> {
            String errorDetails = "Problem while serializing promotion request for environment [%s]".formatted(((BridgeCommandPayload)bridgeCommand.getPayload()).environmentId());
            log.warn(errorDetails);
            return new BridgeReply(bridgeCommand.getId(), errorDetails);
        });
    }

    @Generated
    public PromoteApiOperationHandler(PromotionService promotionService, InstallationService installationService, ObjectMapper objectMapper) {
        this.promotionService = promotionService;
        this.installationService = installationService;
        this.objectMapper = objectMapper;
    }
}

