/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.listener;

import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.plugin.ManagementApiServicesManager;
import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.service.event.ApiEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiEventListener
implements EventListener<ApiEvent, Api> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiEventListener.class);
    private static final ApiAdapter apiAdapter = ApiAdapter.INSTANCE;
    private final ManagementApiServicesManager managementApiServicesManager;

    public ApiEventListener(EventManager eventManager, ManagementApiServicesManager managementApiServicesManager) {
        this.managementApiServicesManager = managementApiServicesManager;
        eventManager.subscribeForEvents((EventListener)this, ApiEvent.class);
    }

    public void onEvent(Event<ApiEvent, Api> event) {
        Api eventPayload = (Api)event.content();
        if (!ApiEventListener.isV4Api(eventPayload)) {
            return;
        }
        io.gravitee.apim.core.api.model.Api api = apiAdapter.toCoreModel(eventPayload);
        switch ((ApiEvent)event.type()) {
            case DEPLOY: {
                this.onApiDeploy(api);
                break;
            }
            case UNDEPLOY: {
                this.onApiUndeploy(api);
                break;
            }
            case UPDATE: {
                this.onApiUpdate(api);
                break;
            }
            case START_DYNAMIC_PROPERTY_V4: {
                this.onDynamicPropertiesStarted(api);
                break;
            }
            case STOP_DYNAMIC_PROPERTY_V4: {
                this.onDynamicPropertiesStopped(api);
            }
        }
    }

    private void onDynamicPropertiesStopped(io.gravitee.apim.core.api.model.Api api) {
        log.info("stopping Dynamic properties event for api: {}", (Object)api.getId());
        this.managementApiServicesManager.stopDynamicProperties(api);
    }

    private void onDynamicPropertiesStarted(io.gravitee.apim.core.api.model.Api api) {
        log.info("starting Dynamic properties event for api: {}", (Object)api.getId());
        this.managementApiServicesManager.startDynamicProperties(api);
    }

    private void onApiDeploy(io.gravitee.apim.core.api.model.Api api) {
        log.debug("Dispatching DEPLOY event for api: {}", (Object)api.getId());
        this.managementApiServicesManager.deployServices(api);
    }

    private void onApiUndeploy(io.gravitee.apim.core.api.model.Api api) {
        log.debug("Dispatching UNDEPLOY event for api: {}", (Object)api.getId());
        this.managementApiServicesManager.undeployServices(api);
    }

    private void onApiUpdate(io.gravitee.apim.core.api.model.Api api) {
        log.debug("Dispatching UPDATE event for api: {}", (Object)api.getId());
        this.managementApiServicesManager.updateServices(api);
    }

    private static boolean isV4Api(Api eventPayload) {
        return eventPayload.getDefinitionVersion() != null && eventPayload.getDefinitionVersion().equals((Object)DefinitionVersion.V4);
    }
}

