/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.application;

import io.gravitee.apim.core.application.domain_service.ValidateApplicationSettingsDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.model.application.OAuthClientSettings;
import io.gravitee.rest.api.model.application.SimpleApplicationSettings;
import io.gravitee.rest.api.model.configuration.application.ApplicationGrantTypeEntity;
import io.gravitee.rest.api.model.configuration.application.ApplicationTypeEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.application.ApplicationTypeService;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import joptsimple.internal.Strings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ValidateApplicationSettingsDomainServiceImpl
implements ValidateApplicationSettingsDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateApplicationSettingsDomainServiceImpl.class);
    private final ApplicationRepository applicationRepository;
    private final ApplicationTypeService applicationTypeService;
    private final ParameterService parameterService;

    public ValidateApplicationSettingsDomainServiceImpl(@Lazy ApplicationRepository applicationRepository, ApplicationTypeService applicationTypeService, ParameterService parameterService) {
        this.applicationRepository = applicationRepository;
        this.applicationTypeService = applicationTypeService;
        this.parameterService = parameterService;
    }

    @Override
    public Validator.Result<ValidateApplicationSettingsDomainService.Input> validateAndSanitize(ValidateApplicationSettingsDomainService.Input input) {
        if (input.settings() != null) {
            if (input.settings().getApp() != null) {
                return this.validateAndSanitizeSimpleSettings(input);
            }
            return this.validateAndSanitizeOAuthSettings(input);
        }
        return Validator.Result.ofValue(input.sanitized(ApplicationSettings.builder().app(new SimpleApplicationSettings()).build()));
    }

    private Validator.Result<ValidateApplicationSettingsDomainService.Input> validateAndSanitizeSimpleSettings(ValidateApplicationSettingsDomainService.Input input) {
        ApplicationSettings.ApplicationSettingsBuilder sanitizedBuilder = input.settings().toBuilder();
        SimpleApplicationSettings simpleSettings = input.settings().getApp().toBuilder().build();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        if (StringUtils.isNotEmpty(simpleSettings.getClientId())) {
            errors.addAll(this.validateClientId(input.auditInfo().environmentId(), input.applicationId(), simpleSettings));
        }
        return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.app(simpleSettings).build()), errors);
    }

    private Validator.Result<ValidateApplicationSettingsDomainService.Input> validateAndSanitizeOAuthSettings(ValidateApplicationSettingsDomainService.Input input) {
        ApplicationSettings.ApplicationSettingsBuilder sanitizedBuilder = input.settings().toBuilder();
        OAuthClientSettings oauthSettings = input.settings().getOauth().toBuilder().build();
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        if (!this.isClientRegistrationEnabled(input.auditInfo())) {
            errors.add(Validator.Error.severe("configuring OAuth requires client registration to be enabled on environment [%s]", input.auditInfo().environmentId()));
        }
        ApplicationTypeEntity appType = this.applicationTypeService.getApplicationType(oauthSettings.getApplicationType());
        errors.addAll(this.validateGrantTypes(appType, oauthSettings));
        errors.addAll(this.validateRedirectURIs(appType, oauthSettings));
        oauthSettings.setResponseTypes(this.getResponseTypes(appType, oauthSettings));
        return Validator.Result.ofBoth(input.sanitized(sanitizedBuilder.oauth(oauthSettings).build()), errors);
    }

    private List<Validator.Error> validateGrantTypes(ApplicationTypeEntity type, OAuthClientSettings settings) {
        List<String> allowedGrantTypes = this.getAllowedGrantTypes(type);
        List<String> mandatoryGrantTypes = this.getMandatoryGrantTypes(type);
        ArrayList grantTypes = new ArrayList(settings.getGrantTypes());
        if (CollectionUtils.isEmpty(grantTypes)) {
            return List.of(Validator.Error.severe("OAuth application of type [%s] must have at least one of [%s] as a grant type", type.getName(), Strings.join(allowedGrantTypes, (String)",")));
        }
        if (!grantTypes.containsAll(mandatoryGrantTypes)) {
            return List.of(Validator.Error.severe("OAuth application of type [%s] must have at least [%s] as a grant type", type.getName(), Strings.join(mandatoryGrantTypes, (String)",")));
        }
        grantTypes.removeAll(allowedGrantTypes);
        if (CollectionUtils.isNotEmpty(grantTypes)) {
            return List.of(Validator.Error.severe("unknown grant types [%s] for OAuth application of type [%s]", Strings.join(grantTypes, (String)","), type.getName()));
        }
        return List.of();
    }

    private List<Validator.Error> validateRedirectURIs(ApplicationTypeEntity type, OAuthClientSettings settings) {
        List redirectURIs = settings.getRedirectUris();
        if (Boolean.TRUE.equals(type.getRequires_redirect_uris()) && CollectionUtils.isEmpty(redirectURIs)) {
            return List.of(Validator.Error.severe("application type [%s] requires redirect URIs to be defined", type.getName()));
        }
        if (CollectionUtils.isEmpty(redirectURIs)) {
            settings.setRedirectUris(List.of());
            return List.of();
        }
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        for (String uri : redirectURIs) {
            try {
                URL validURL = URI.create(uri).toURL();
                log.debug("redirect URI [{}] has been validated", (Object)validURL);
            }
            catch (IllegalArgumentException | MalformedURLException e) {
                errors.add(Validator.Error.severe("invalid redirect URI [%s]", uri));
            }
        }
        return errors;
    }

    private List<String> getAllowedGrantTypes(ApplicationTypeEntity type) {
        return type.getAllowed_grant_types() == null ? List.of() : type.getAllowed_grant_types().stream().map(ApplicationGrantTypeEntity::getType).toList();
    }

    private List<String> getMandatoryGrantTypes(ApplicationTypeEntity type) {
        return type.getMandatory_grant_types() == null ? List.of() : type.getMandatory_grant_types().stream().map(ApplicationGrantTypeEntity::getType).toList();
    }

    private List<String> getResponseTypes(ApplicationTypeEntity type, OAuthClientSettings settings) {
        return type.getAllowed_grant_types().stream().filter(grantType -> settings.getGrantTypes().contains(grantType.getType())).map(ApplicationGrantTypeEntity::getResponse_types).flatMap(Collection::stream).distinct().toList();
    }

    private boolean isClientRegistrationEnabled(AuditInfo auditInfo) {
        return this.parameterService.findAsBoolean(new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId()), Key.APPLICATION_REGISTRATION_ENABLED, auditInfo.environmentId(), ParameterReferenceType.ENVIRONMENT);
    }

    private List<Validator.Error> validateClientId(String environmentId, String applicationId, SimpleApplicationSettings settings) {
        try {
            String clientId = settings.getClientId();
            List<Application> activeApps = this.applicationRepository.findAllByEnvironment(environmentId, new ApplicationStatus[]{ApplicationStatus.ACTIVE}).stream().filter(app -> !app.getId().equals(applicationId)).toList();
            for (Application app2 : activeApps) {
                if (app2.getMetadata() == null || !clientId.equals(app2.getMetadata().get("client_id"))) continue;
                return List.of(Validator.Error.severe("client id [%s] is already defined for application [%s] with id [%s] on environment [%s]", settings.getClientId(), app2.getName(), app2.getId(), environmentId));
            }
            return List.of();
        }
        catch (TechnicalException e) {
            log.error("unable to find active applications", (Throwable)e);
            throw new TechnicalDomainException(e.getMessage());
        }
    }
}

