/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.flow;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.infra.adapter.FlowAdapter;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class FlowCrudServiceImpl
extends TransactionalService
implements FlowCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowCrudServiceImpl.class);
    private final FlowRepository flowRepository;

    public FlowCrudServiceImpl(@Lazy FlowRepository flowRepository) {
        this.flowRepository = flowRepository;
    }

    @Override
    public List<Flow> savePlanFlows(String planId, List<Flow> flows) {
        return FlowAdapter.INSTANCE.toFlowV4(this.save(FlowReferenceType.PLAN, planId, flows));
    }

    @Override
    public void savePlanFlowsV2(String planId, List<io.gravitee.definition.model.flow.Flow> flows) {
        this.saveV2(FlowReferenceType.PLAN, planId, flows);
    }

    @Override
    public void saveApiFlowsV2(String apiId, List<io.gravitee.definition.model.flow.Flow> flows) {
        this.saveV2(FlowReferenceType.API, apiId, flows);
    }

    @Override
    public List<Flow> saveApiFlows(String apiId, List<Flow> flows) {
        return FlowAdapter.INSTANCE.toFlowV4(this.save(FlowReferenceType.API, apiId, flows));
    }

    @Override
    public List<Flow> getApiV4Flows(String apiId) {
        return this.getHttpV4(FlowReferenceType.API, apiId);
    }

    @Override
    public List<Flow> getPlanV4Flows(String planId) {
        return this.getHttpV4(FlowReferenceType.PLAN, planId);
    }

    @Override
    public List<io.gravitee.definition.model.flow.Flow> getApiV2Flows(String apiId) {
        return this.getV2(FlowReferenceType.API, apiId);
    }

    @Override
    public List<io.gravitee.definition.model.flow.Flow> getPlanV2Flows(String planId) {
        return this.getV2(FlowReferenceType.PLAN, planId);
    }

    @Override
    public List<NativeFlow> saveNativeApiFlows(String apiId, List<NativeFlow> flows) {
        return FlowAdapter.INSTANCE.toNativeFlow(this.save(FlowReferenceType.API, apiId, flows));
    }

    @Override
    public List<NativeFlow> saveNativePlanFlows(String planId, List<NativeFlow> flows) {
        return FlowAdapter.INSTANCE.toNativeFlow(this.save(FlowReferenceType.PLAN, planId, flows));
    }

    @Override
    public List<NativeFlow> getNativeApiFlows(String apiId) {
        return this.getNativeV4(FlowReferenceType.API, apiId);
    }

    @Override
    public List<NativeFlow> getNativePlanFlows(String planId) {
        return this.getNativeV4(FlowReferenceType.PLAN, planId);
    }

    private List<io.gravitee.repository.management.model.flow.Flow> save(FlowReferenceType flowReferenceType, String referenceId, List<? extends AbstractFlow> flows) {
        try {
            log.debug("Save flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            if (CollectionUtils.isEmpty(flows)) {
                this.flowRepository.deleteByReferenceIdAndReferenceType(referenceId, flowReferenceType);
                return List.of();
            }
            Map dbFlowsById = this.flowRepository.findByReference(flowReferenceType, referenceId).stream().collect(Collectors.toMap(io.gravitee.repository.management.model.flow.Flow::getId, Function.identity()));
            Set flowIdsToSave = flows.stream().map(AbstractFlow::getId).filter(Objects::nonNull).collect(Collectors.toSet());
            Set flowIdsToDelete = dbFlowsById.keySet().stream().filter(Predicate.not(flowIdsToSave::contains)).collect(Collectors.toSet());
            if (!flowIdsToDelete.isEmpty()) {
                this.flowRepository.deleteAllById(flowIdsToDelete);
            }
            ArrayList<io.gravitee.repository.management.model.flow.Flow> savedFlows = new ArrayList<io.gravitee.repository.management.model.flow.Flow>();
            for (int order = 0; order < flows.size(); ++order) {
                AbstractFlow flow = flows.get(order);
                io.gravitee.repository.management.model.flow.Flow dbFlow = flow.getId() == null || !dbFlowsById.containsKey(flow.getId()) ? (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.create((Object)FlowAdapter.INSTANCE.toRepositoryFromAbstract(flow, flowReferenceType, referenceId, order)) : (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.update((Object)FlowAdapter.INSTANCE.toRepositoryUpdateFromAbstract((io.gravitee.repository.management.model.flow.Flow)dbFlowsById.get(flow.getId()), flow, order));
                savedFlows.add(dbFlow);
            }
            return savedFlows;
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to save flows for " + String.valueOf(flowReferenceType) + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }

    private List<io.gravitee.definition.model.flow.Flow> getV2(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            log.debug("Get flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(FlowAdapter.INSTANCE::toFlowV2).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to get flows for " + String.valueOf(flowReferenceType) + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }

    private List<Flow> getHttpV4(FlowReferenceType flowReferenceType, String referenceId) {
        return this.getRepositoryV4(flowReferenceType, referenceId).map(FlowAdapter.INSTANCE::toFlowV4).collect(Collectors.toList());
    }

    private List<NativeFlow> getNativeV4(FlowReferenceType flowReferenceType, String referenceId) {
        return this.getRepositoryV4(flowReferenceType, referenceId).map(FlowAdapter.INSTANCE::toNativeFlow).collect(Collectors.toList());
    }

    private Stream<io.gravitee.repository.management.model.flow.Flow> getRepositoryV4(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            log.debug("Get flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder));
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to get flows for " + String.valueOf(flowReferenceType) + ": " + referenceId;
            log.error(error, (Throwable)ex);
            throw new TechnicalDomainException(error, ex);
        }
    }

    private void saveV2(FlowReferenceType flowReferenceType, String referenceId, @Nullable List<io.gravitee.definition.model.flow.Flow> flows) {
        try {
            log.debug("Save flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            if (CollectionUtils.isEmpty(flows)) {
                this.flowRepository.deleteByReferenceIdAndReferenceType(referenceId, flowReferenceType);
                return;
            }
            Map dbFlowsById = CollectionUtils.stream(this.flowRepository.findByReference(flowReferenceType, referenceId)).collect(Collectors.toMap(io.gravitee.repository.management.model.flow.Flow::getId, Function.identity()));
            Set flowIdsToSave = flows.stream().flatMap(f -> Stream.ofNullable(f.getId())).collect(Collectors.toSet());
            Set flowIdsToDelete = dbFlowsById.keySet().stream().filter(Predicate.not(flowIdsToSave::contains)).collect(Collectors.toSet());
            if (!flowIdsToDelete.isEmpty()) {
                this.flowRepository.deleteAllById(flowIdsToDelete);
            }
            for (int order = 0; order < flows.size(); ++order) {
                io.gravitee.definition.model.flow.Flow flow = flows.get(order);
                if (flow.getId() == null || !dbFlowsById.containsKey(flow.getId())) {
                    this.flowRepository.create((Object)FlowAdapter.INSTANCE.toRepository(flow, flowReferenceType, referenceId, order));
                    continue;
                }
                this.flowRepository.update((Object)FlowAdapter.INSTANCE.toRepositoryUpdate((io.gravitee.repository.management.model.flow.Flow)dbFlowsById.get(flow.getId()), flow, order));
            }
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to save flows for " + String.valueOf(flowReferenceType) + ": " + referenceId;
            throw new TechnicalDomainException(error, ex);
        }
    }
}

