/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.converter.oai;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.definition.model.v4.endpointgroup.Endpoint;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OAIToEndpointGroupsConverter {
    public static OAIToEndpointGroupsConverter INSTANCE = new OAIToEndpointGroupsConverter();
    private static final String DEFAULT_ENDPOINT_GROUP_NAME = "default-group";
    private static final String DEFAULT_ENDPOINT_NAME = "default";
    private static final String DEFAULT_ENDPOINT_TYPE = "http-proxy";

    List<EndpointGroup> convert(List<Server> servers, List<String> serverUrls) {
        if (CollectionUtils.isEmpty(servers)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(((EndpointGroup.EndpointGroupBuilder)((EndpointGroup.EndpointGroupBuilder)((EndpointGroup.EndpointGroupBuilder)EndpointGroup.builder().name(DEFAULT_ENDPOINT_GROUP_NAME)).type(DEFAULT_ENDPOINT_TYPE)).endpoints(serverUrls.stream().map(url -> {
            ObjectNode configurationNode = new ObjectMapper().createObjectNode();
            configurationNode.put("target", url);
            return ((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)((Endpoint.EndpointBuilder)Endpoint.builder().name((String)(serverUrls.size() == 1 ? DEFAULT_ENDPOINT_NAME : "server" + (serverUrls.indexOf(url) + 1)))).configuration(configurationNode.toString())).weight(1)).inheritConfiguration(true)).type(DEFAULT_ENDPOINT_TYPE)).build();
        }).collect(Collectors.toList()))).build());
    }
}

