/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.domain_service.CheckContextExistsDomainService;
import io.gravitee.apim.core.portal_page.domain_service.PageExistsSpecification;
import io.gravitee.apim.core.portal_page.model.ExpandsViewContext;
import io.gravitee.apim.core.portal_page.model.PortalPageWithViewDetails;
import io.gravitee.apim.core.portal_page.model.PortalViewContext;
import io.gravitee.apim.core.portal_page.query_service.PortalPageQueryService;
import java.util.List;
import lombok.Generated;

@UseCase
public class GetPortalPageUseCase {
    private final CheckContextExistsDomainService checkContextExistsDomainService;
    private final PortalPageQueryService portalPageQueryService;

    public Output execute(Input input) {
        PageExistsSpecification<PortalViewContext> spec = PageExistsSpecification.byPortalViewContext(ctx -> this.checkContextExistsDomainService.portalViewContextExists(input.environmentId(), (PortalViewContext)((Object)ctx)));
        PortalViewContext context = input.pageType;
        spec.throwIfNotSatisfied(input.pageType);
        List<PortalPageWithViewDetails> pages = this.portalPageQueryService.findByEnvironmentIdAndContext(input.environmentId(), context, input.expands);
        return new Output(pages);
    }

    @Generated
    public GetPortalPageUseCase(CheckContextExistsDomainService checkContextExistsDomainService, PortalPageQueryService portalPageQueryService) {
        this.checkContextExistsDomainService = checkContextExistsDomainService;
        this.portalPageQueryService = portalPageQueryService;
    }

    public record Input(String environmentId, PortalViewContext pageType, List<ExpandsViewContext> expands) {
    }

    public record Output(List<PortalPageWithViewDetails> pages) {
    }
}

