/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.exception.ApiDeprecatedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.PlanValidatorDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.flow.AbstractFlow;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.listener.AbstractListener;
import io.gravitee.definition.model.v4.listener.entrypoint.AbstractEntrypoint;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.rest.api.service.common.UuidString;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@DomainService
public class CreatePlanDomainService {
    private final PlanValidatorDomainService planValidatorDomainService;
    private final FlowValidationDomainService flowValidationDomainService;
    private final PlanCrudService planCrudService;
    private final FlowCrudService flowCrudService;
    private final AuditDomainService auditService;

    public CreatePlanDomainService(PlanValidatorDomainService planValidatorDomainService, FlowValidationDomainService flowValidationDomainService, PlanCrudService planCrudService, FlowCrudService flowCrudService, AuditDomainService auditDomainService) {
        this.planValidatorDomainService = planValidatorDomainService;
        this.flowValidationDomainService = flowValidationDomainService;
        this.planCrudService = planCrudService;
        this.flowCrudService = flowCrudService;
        this.auditService = auditDomainService;
    }

    public PlanWithFlows create(Plan plan, List<? extends AbstractFlow> flows, Api api, AuditInfo auditInfo) {
        DefinitionVersion definitionVersion = api.getDefinitionVersion();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"V4", "FEDERATED", "FEDERATED_AGENT", "V2", "V1"}, (DefinitionVersion)definitionVersion, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> this.createV4ApiPlan(plan, flows, api, auditInfo);
            case 1, 2 -> this.createFederatedApiPlan(plan, auditInfo);
            case 3 -> this.createV2ApiPlan(plan, flows, api, auditInfo);
            case 4 -> throw new IllegalStateException(String.valueOf(api.getDefinitionVersion()) + " is not supported");
            case -1 -> throw new IllegalStateException(String.valueOf(api.getDefinitionVersion()) + " is not supported");
        };
    }

    private PlanWithFlows createV4ApiPlan(Plan plan, List<? extends AbstractFlow> flows, Api api, AuditInfo auditInfo) {
        if (api.isDeprecated()) {
            throw new ApiDeprecatedException(plan.getApiId());
        }
        List<? extends AbstractListener<? extends AbstractEntrypoint>> listeners = api.getApiListeners();
        if (!listeners.isEmpty()) {
            this.planValidatorDomainService.validatePlanSecurityAgainstEntrypoints(plan.getPlanSecurity(), listeners.stream().map(AbstractListener::getType).toList());
        }
        this.planValidatorDomainService.validatePlanSecurity(plan, auditInfo.organizationId(), auditInfo.environmentId(), api.getType());
        this.planValidatorDomainService.validatePlanTagsAgainstApiTags(plan.getTags(), api.getTags());
        this.planValidatorDomainService.validateGeneralConditionsPageStatus(plan);
        if (api.isNative()) {
            return this.createNativeV4ApiPlan(plan, flows, api, auditInfo);
        }
        return this.createHttpV4ApiPlan(plan, flows, api, auditInfo);
    }

    private PlanWithFlows createNativeV4ApiPlan(Plan plan, List<NativeFlow> flows, Api api, AuditInfo auditInfo) {
        List<NativeFlow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitizeNativeV4(flows);
        Plan createdPlan = this.planCrudService.create((Plan)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)plan.toBuilder().id(plan.getId() != null ? plan.getId() : UuidString.generateRandom())).apiId(api.getId())).apiType(api.getType())).createdAt(TimeProvider.now())).updatedAt(TimeProvider.now())).needRedeployAt(Date.from(TimeProvider.instantNow()))).publishedAt(plan.isPublished() ? TimeProvider.now() : null)).build());
        List<NativeFlow> createdFlows = this.flowCrudService.saveNativePlanFlows(createdPlan.getId(), sanitizedFlows);
        this.createAuditLog(createdPlan, auditInfo);
        return new PlanWithFlows(createdPlan, createdFlows);
    }

    private PlanWithFlows createHttpV4ApiPlan(Plan plan, List<Flow> flows, Api api, AuditInfo auditInfo) {
        List<Flow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitizeHttpV4(api.getType(), flows);
        this.flowValidationDomainService.validatePathParameters(api.getType(), api.getApiDefinitionHttpV4().getFlows() != null ? api.getApiDefinitionHttpV4().getFlows().stream() : Stream.empty(), sanitizedFlows.stream());
        Plan createdPlan = this.planCrudService.create((Plan)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)plan.toBuilder().id(plan.getId() != null ? plan.getId() : UuidString.generateRandom())).apiId(api.getId())).apiType(api.getType())).createdAt(TimeProvider.now())).updatedAt(TimeProvider.now())).needRedeployAt(Date.from(TimeProvider.instantNow()))).publishedAt(plan.isPublished() ? TimeProvider.now() : null)).build());
        List<Flow> createdFlows = this.flowCrudService.savePlanFlows(createdPlan.getId(), sanitizedFlows);
        this.createAuditLog(createdPlan, auditInfo);
        return new PlanWithFlows(createdPlan, createdFlows);
    }

    private PlanWithFlows createFederatedApiPlan(Plan plan, AuditInfo auditInfo) {
        Plan createdPlan = this.planCrudService.create(plan);
        this.createAuditLog(createdPlan, auditInfo);
        return new PlanWithFlows(createdPlan, Collections.emptyList());
    }

    private PlanWithFlows createV2ApiPlan(Plan plan, List<? extends AbstractFlow> flows, Api api, AuditInfo auditInfo) {
        if (api.isDeprecated()) {
            throw new ApiDeprecatedException(plan.getApiId());
        }
        this.planValidatorDomainService.validatePlanSecurity(plan, auditInfo.organizationId(), auditInfo.environmentId(), api.getType());
        this.planValidatorDomainService.validatePlanTagsAgainstApiTags(plan.getTags(), api.getTags());
        this.planValidatorDomainService.validateGeneralConditionsPageStatus(plan);
        Plan createdPlan = this.planCrudService.create((Plan)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)plan.toBuilder().id(plan.getId() != null ? plan.getId() : UuidString.generateRandom())).apiId(api.getId())).apiType(api.getType())).createdAt(TimeProvider.now())).updatedAt(TimeProvider.now())).needRedeployAt(Date.from(TimeProvider.instantNow()))).publishedAt(plan.isPublished() ? TimeProvider.now() : null)).build());
        this.createAuditLog(createdPlan, auditInfo);
        return new PlanWithFlows(createdPlan, flows);
    }

    private void createAuditLog(Plan createdPlan, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(createdPlan.getApiId()).event(PlanAuditEvent.PLAN_CREATED).actor(auditInfo.actor()).newValue(createdPlan).createdAt(createdPlan.getCreatedAt()).properties(Map.of(AuditProperties.PLAN, createdPlan.getId())).build());
    }
}

