/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.newtai.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.newtai.model.ELGenQuery;
import io.gravitee.apim.core.newtai.model.ELGenReply;
import io.gravitee.apim.core.newtai.service_provider.NewtAIProvider;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@UseCase
public class GenerateELUseCase {
    private final NewtAIProvider newtAIProvider;
    private static final String CONTEXT = "{\n  \"api\": {\n    \"id\": \"c9f75e22-1a9a-4f46-b75e-221a9a7f465a\",\n    \"name\": \"Echo\",\n    \"properties\": {\n      \"propB\": \"Beta\",\n      \"propA\": \"Alpha\"\n    },\n    \"version\": \"1\"\n  },\n  \"context\": {\n    \"attributes\": {\n      \"application\": \"6989925b-d9fe-41f2-8992-5bd9fed1f2a7\",\n      \"api.deployed-at\": 1750402605200,\n      \"context-path\": \"/echo/\",\n      \"user-id\": \"7f1008dd-300a-4bc7-9008-dd300a6bc7db\",\n      \"plan\": \"bd3a24ad-1e6f-4f3c-ba24-ad1e6f6f3c4e\",\n      \"clientIdentifier\": \"7f1008dd-300a-4bc7-9008-dd300a6bc7db\",\n      \"organization\": \"DEFAULT\",\n      \"environment\": \"DEFAULT\",\n      \"CustomAttribute\": \"My custom Atribute Value\",\n      \"api.name\": \"Echo\",\n      \"api\": \"c9f75e22-1a9a-4f46-b75e-221a9a7f465a\",\n      \"api-key\": \"bdf382f2-e323-4647-b382-f2e323464723\"\n    }\n  },\n  \"dictionaries\": {\n    \"color-dictionary\": {\n      \"Red\": \"142\",\n      \"Blue\": \"no blue\",\n      \"Black\": \"{\\\"id\\\": \\\"123456789\\\"}\"\n    }\n  },\n  \"endpoints\": {\n    \"Default HTTP proxy\": \"Default HTTP proxy:\",\n    \"Default HTTP proxy group\": \"Default HTTP proxy group:\"\n  },\n  \"node\": {\n    \"id\": \"48f3e688-e83f-400d-b3e6-88e83f000de8\",\n    \"shardingTags\": [],\n    \"version\": \"4.8.0-alpha.3-SNAPSHOT\"\n  },\n  \"request\": {\n    \"contextPath\": \"/echo/\",\n    \"headers\": {\n      \"Accept\": [\n        \"*/*\"\n      ],\n      \"X-Gravitee-Request-Id\": [\n        \"e2ac4ba5-e44e-40e1-ac4b-a5e44ec0e1df\"\n      ],\n      \"X-Gravitee-Transaction-Id\": [\n        \"e2ac4ba5-e44e-40e1-ac4b-a5e44ec0e1df\"\n      ],\n      \"Postman-Token\": [\n        \"a8c4139c-5df9-4a18-b010-c5a7c7cb508b\"\n      ],\n      \"User-Agent\": [\n        \"PostmanRuntime/7.44.0\"\n      ],\n      \"Cache-Control\": [\n        \"no-cache\"\n      ],\n      \"Test_Endpoints_header\": [\n        \"aaaa\"\n      ]\n    },\n    \"id\": \"e2ac4ba5-e44e-40e1-ac4b-a5e44ec0e1df\",\n    \"localAddress\": \"0:0:0:0:0:0:0:1\",\n    \"method\": \"GET\",\n    \"params\": {\n      \"queryParams\": [\n        \"foo\"\n      ],\n      \"t\": [\n        \"1\",\n        \"2\"\n      ]\n    },\n    \"path\": \"/echo\",\n    \"pathInfo\": \"\",\n    \"pathInfos\": [\n      \"\"\n    ],\n    \"pathParams\": {},\n    \"paths\": [\n      \"\",\n      \"echo\"\n    ],\n    \"remoteAddress\": \"0:0:0:0:0:0:0:1\",\n    \"scheme\": \"http\",\n    \"ssl\": {\n      \"client\": \"[inaccessible]\",\n      \"clientHost\": \"[inaccessible]\",\n      \"clientPort\": \"[inaccessible]\",\n      \"server\": \"[inaccessible]\"\n    },\n    \"timestamp\": 1750429186674,\n    \"transactionId\": \"e2ac4ba5-e44e-40e1-ac4b-a5e44ec0e1df\",\n    \"uri\": \"/echo?queryParams=foo&t=1&t=2\",\n    \"version\": \"HTTP_1_1\"\n  },\n  \"response\": {\n    \"headers\": {\n      \"X-Gravitee-Transaction-Id\": [\n        \"e2ac4ba5-e44e-40e1-ac4b-a5e44ec0e1df\"\n      ],\n      \"X-Gravitee-Client-Identifier\": [\n        \"7f1008dd-300a-4bc7-9008-dd300a6bc7db\"\n      ],\n      \"Sozu-Id\": [\n        \"01JY6VBEP9P1CPKJNVBFGRXXFE\"\n      ],\n      \"Content-Type\": [\n        \"application/json\"\n      ],\n      \"Content-Length\": [\n        \"431\"\n      ],\n      \"X-Gravitee-Request-Id\": [\n        \"38d41bea-5308-4d18-941b-ea53088d18ae\"\n      ]\n    },\n    \"status\": 200\n  },\n  \"subscription\": {\n    \"applicationName\": \"Default application\",\n    \"id\": \"7f1008dd-300a-4bc7-9008-dd300a6bc7db\",\n    \"metadata\": {\n      \"subscriptionMetadata\": \"Foo\"\n    },\n    \"type\": \"STANDARD\"\n  }\n}\n";

    public Single<Output> execute(Input input) {
        Input inputWithContext = input.withProperties(Map.of("elContextVariables", CONTEXT));
        return this.newtAIProvider.generateEL(inputWithContext).map(Output::new);
    }

    @Generated
    public GenerateELUseCase(NewtAIProvider newtAIProvider) {
        this.newtAIProvider = newtAIProvider;
    }

    public record Input(String message, Map<String, String> properties, AuditInfo auditInfo) implements ELGenQuery
    {
        private final Map<String, String> properties;

        public Input(String message, AuditInfo auditInfo) {
            this(message, new HashMap<String, String>(), auditInfo);
        }

        public Input withProperties(Map<String, String> properties) {
            HashMap<String, String> props = new HashMap<String, String>(this.properties);
            props.putAll(properties);
            return new Input(this.message, props, this.auditInfo);
        }

        public Input withApiId(String apiId) {
            HashMap<String, String> props = new HashMap<String, String>(this.properties);
            props.put("apiId", apiId);
            return new Input(this.message, props, this.auditInfo);
        }

        @Override
        public Map<String, String> properties() {
            return Collections.unmodifiableMap(this.properties);
        }
    }

    public record Output(String message, FeedbackId feedbackId) {
        public Output(ELGenReply reply) {
            this(reply.message(), new FeedbackId(reply.feedbackId()));
        }

        public record FeedbackId(String chatId, String userMessageId, String agentMessageId) {
            public FeedbackId(ELGenReply.FeedbackId feedbackId) {
                this(feedbackId.chatId(), feedbackId.userMessageId(), feedbackId.agentMessageId());
            }
        }
    }
}

