/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_key.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api_key.domain_service.RevokeApiKeyDomainService;
import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.core.api_key.query_service.ApiKeyQueryService;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiKeyNotFoundException;
import io.gravitee.rest.api.service.exceptions.InvalidApplicationApiKeyModeException;
import java.util.Optional;

@UseCase
public class RevokeApplicationApiKeyUseCase {
    private final ApplicationCrudService applicationCrudService;
    private final ApiKeyQueryService apiKeyQueryService;
    private final RevokeApiKeyDomainService revokeApiKeyDomainService;

    public RevokeApplicationApiKeyUseCase(ApplicationCrudService applicationCrudService, ApiKeyQueryService apiKeyQueryService, RevokeApiKeyDomainService revokeApiKeyDomainService) {
        this.applicationCrudService = applicationCrudService;
        this.apiKeyQueryService = apiKeyQueryService;
        this.revokeApiKeyDomainService = revokeApiKeyDomainService;
    }

    public Output execute(Input input) {
        BaseApplicationEntity application = this.applicationCrudService.findById(new ExecutionContext(input.auditInfo().organizationId(), input.auditInfo().environmentId()), input.applicationId());
        Optional<ApiKeyEntity> apiKey = this.apiKeyQueryService.findById(input.apiKeyId());
        if (apiKey.isEmpty()) {
            throw new ApiKeyNotFoundException();
        }
        if (!apiKey.get().getApplicationId().equals(application.getId())) {
            throw new ApiKeyNotFoundException();
        }
        if (!application.hasApiKeySharedMode()) {
            throw new InvalidApplicationApiKeyModeException(String.format("Invalid operation for API Key mode [%s] of application [%s]", application.getApiKeyMode(), application.getId()));
        }
        return new Output(this.revokeApiKeyDomainService.revoke(apiKey.get(), input.auditInfo()));
    }

    public record Input(String apiKeyId, String applicationId, AuditInfo auditInfo) {
    }

    public record Output(ApiKeyEntity apiKey) {
    }
}

