/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.apim.core.api.model.utils.MigrationResult;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.selector.ConditionSelector;
import io.gravitee.definition.model.v4.flow.selector.HttpSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowMigration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowMigration.class);
    private final ObjectMapper OBJECT_MAPPER;
    private static final Collection<String> INCOMPATIBLES_POLICIES = Set.of("cloud-events", "html-json", "message-filtering", "metrics-reporter", "policy-interrupt", "policy-wssecurity-authentication");
    private static final Collection<String> GRAVITEE_POLICIES = Set.of("ai-prompt-guard-rails", "ai-prompt-token-tracking", "api-key", "avro-json", "avro-protobuf", "aws-lambda", "cache", "cloud-events", "custom-query-parameters-parser", "data-cache", "dynamic-routing", "generate-http-signature", "groovy", "html-json", "http-redirect", "http-signature", "ip-filtering", "javascript", "json-threat-protection", "json-to-json", "json-validation", "json-xml", "jws", "jwt", "key-less", "latency", "message-filtering", "metrics-reporter", "mock", "mtls", "oas-validation", "oauth2", "policy-assign-attributes", "policy-assign-content", "policy-assign-metrics", "policy-basic-authentication", "policy-circuit-breaker", "policy-data-logging-masking", "policy-generate-jwt", "policy-geoip-filtering", "policy-graphql-ratelimit", "policy-http-callout", "policy-interops-a-sp", "policy-interops-r-sp", "policy-interrupt", "policy-openid-userinfo", "policy-override-request-method", "policy-request-validation", "policy-wssecurity-authentication", "protobuf-json", "quota", "rate-limit", "rbac", "regex-threat-protection", "request-content-limit", "resource-filtering", "rest-to-soap", "retry", "spike-arrest", "ssl-enforcement", "status-code", "traffic-shadowing", "transform-headers", "transform-queryparams", "url-rewriting", "ws-security-sign", "xml-json", "xml-threat-protection", "xml-validation", "xslt");

    public MigrationResult<List<Flow>> mapFlows(Iterable<io.gravitee.definition.model.flow.Flow> flows) {
        return CollectionUtils.stream(flows).map(this::mapFlow).collect(MigrationResult.collectList());
    }

    public MigrationResult<Flow> mapFlow(io.gravitee.definition.model.flow.Flow v2Flow) {
        Stream<MigrationResult> preSteps = CollectionUtils.stream(v2Flow.getPre()).map(this::migrateV4).map(step -> step.map(MigratedSteps::pre));
        Stream<MigrationResult> postSteps = CollectionUtils.stream(v2Flow.getPost()).map(this::migrateV4).map(step -> step.map(MigratedSteps::post));
        MigrationResult reduce = Stream.concat(preSteps, postSteps).reduce(MigrationResult.value(new MigratedSteps()), (a, b) -> a.foldLeft(b, MigratedSteps::merge));
        return reduce.map(e -> e != null ? ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(v2Flow.getId())).selectors(Stream.concat(this.nullIfEmpty(v2Flow.getCondition()) == null ? Stream.empty() : Stream.of(ConditionSelector.builder().condition(v2Flow.getCondition()).build()), Stream.of(HttpSelector.builder().methods(v2Flow.getMethods()).pathOperator(v2Flow.getOperator()).path(v2Flow.getPath()).build())).toList()).request(e.pre()).response(e.post()).name(v2Flow.getName())).enabled(v2Flow.isEnabled())).build() : null);
    }

    private MigrationResult<io.gravitee.definition.model.v4.flow.step.Step> migrateV4(Step v2Step) {
        if (INCOMPATIBLES_POLICIES.contains(v2Step.getPolicy())) {
            return MigrationResult.issue("Unable to migrate the API as Policy %s is not compatible with V4 APIs".formatted(v2Step.getPolicy()), MigrationResult.State.IMPOSSIBLE);
        }
        if (!GRAVITEE_POLICIES.contains(v2Step.getPolicy())) {
            return MigrationResult.issue("Unable to migrate the API as Policy %s is not a Gravitee policy. Please ensure your API uses Gravitee policies compatible with V4 API before migrating to V4".formatted(v2Step.getPolicy()), MigrationResult.State.CAN_BE_FORCED);
        }
        MigrationResult<String> config = !"groovy".equals(v2Step.getPolicy()) ? MigrationResult.value(v2Step.getConfiguration()) : this.migrateGroovyPolicy(v2Step.getConfiguration());
        return config.map(cfg -> new io.gravitee.definition.model.v4.flow.step.Step(v2Step.getName(), this.nullIfEmpty(v2Step.getDescription()), v2Step.isEnabled(), v2Step.getPolicy(), cfg, this.nullIfEmpty(v2Step.getCondition()), null));
    }

    private String nullIfEmpty(@Nullable String value) {
        return value == null || value.isBlank() ? null : value;
    }

    private MigrationResult<String> migrateGroovyPolicy(String config) {
        try {
            List<String> v2CfgScripts = List.of("onRequestContentScript", "onResponseContentScript", "onRequestScript", "onResponseScript");
            ObjectNode jsonNode = (ObjectNode)this.OBJECT_MAPPER.readTree(config).deepCopy();
            List<UnaryOperator> upds = v2CfgScripts.stream().filter(arg_0 -> ((ObjectNode)jsonNode).has(arg_0)).map(scriptName -> this.buildV4groovyCfg(jsonNode.get(scriptName).asText(), scriptName.contains("Content"), scriptName.contains("Content"))).toList();
            return switch (CollectionUtils.size(upds)) {
                case 1 -> MigrationResult.value(((ObjectNode)upds.getFirst().apply(jsonNode)).remove(v2CfgScripts).toString());
                case 0 -> MigrationResult.issue("Unable to migrate the API as scripts are missing in the groovy policy configuration. Please ensure there are no missing scripts in the groovy policy configuration", MigrationResult.State.IMPOSSIBLE);
                default -> MigrationResult.issue("Unable to migrate the API as multiple groovy scripts are found in groovy policy configuration (non 'content' scripts are ignored if a 'content' script is present). Please ensure there is only one script in the groovy policy configuration", MigrationResult.State.IMPOSSIBLE);
            };
        }
        catch (JsonProcessingException e) {
            log.error("Unable to parse groovy configuration", (Throwable)e);
            return MigrationResult.issue("Unable to migrate the API as an error occurred while parsing the groovy policy configuration. Please contact support and attach your API definition with the support ticket for debugging", MigrationResult.State.IMPOSSIBLE);
        }
    }

    private UnaryOperator<ObjectNode> buildV4groovyCfg(String script, boolean readContent, boolean overrideContent) {
        return objectNode -> objectNode.put("script", script).put("readContent", readContent).put("overrideContent", overrideContent);
    }

    @Generated
    public FlowMigration(ObjectMapper OBJECT_MAPPER) {
        this.OBJECT_MAPPER = OBJECT_MAPPER;
    }

    private record MigratedSteps(List<io.gravitee.definition.model.v4.flow.step.Step> pre, List<io.gravitee.definition.model.v4.flow.step.Step> post) {
        private MigratedSteps() {
            this(new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>(), new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>());
        }

        public static @Nullable MigratedSteps merge(@Nullable MigratedSteps first, @Nullable MigratedSteps second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            return new MigratedSteps(Stream.concat(CollectionUtils.stream(first.pre), CollectionUtils.stream(second.pre)).toList(), Stream.concat(CollectionUtils.stream(first.post), CollectionUtils.stream(second.post)).toList());
        }

        public static MigratedSteps pre(@Nullable io.gravitee.definition.model.v4.flow.step.Step step) {
            List<Object> steps = step != null ? List.of(step) : List.of();
            return new MigratedSteps(new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>(steps), new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>());
        }

        public static MigratedSteps post(@Nullable io.gravitee.definition.model.v4.flow.step.Step step) {
            List<Object> steps = step != null ? List.of(step) : List.of();
            return new MigratedSteps(new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>(), new ArrayList<io.gravitee.definition.model.v4.flow.step.Step>(steps));
        }
    }
}

