/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.model.AnalyticsQueryParameters;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.application.query_service.ApplicationQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.analytics.TopHitsApps;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentTopAppsByRequestCountUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentTopAppsByRequestCountUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiQueryService apiQueryService;
    private final ApplicationQueryService applicationQueryService;

    public Output execute(Input input) {
        String envId = input.executionContext().getEnvironmentId();
        Map<String, Api> apis = this.getAllApisForEnv(envId);
        List<String> apisIds = apis.keySet().stream().toList();
        log.debug("Searching top Apps hits with all APIs for env: {}", (Object)envId);
        return this.analyticsQueryService.searchTopHitsApps(input.executionContext(), input.parameters().withApiIds(apisIds)).map(topHitsApps -> this.sortByCountAndUpdateTopHitsWithAppNames(envId, (TopHitsApps)topHitsApps)).map(Output::new).orElse(new Output(TopHitsApps.builder().data(List.of()).build()));
    }

    private Map<String, Api> getAllApisForEnv(String envId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(List.of(DefinitionVersion.V4, DefinitionVersion.V2, DefinitionVersion.V1)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).collect(Collectors.toMap(Api::getId, value -> value));
    }

    private TopHitsApps sortByCountAndUpdateTopHitsWithAppNames(String envId, TopHitsApps topHitsApps) {
        Map applications = this.applicationQueryService.findByEnvironment(envId).stream().collect(Collectors.toMap(BaseApplicationEntity::getId, Function.identity()));
        List<TopHitsApps.TopHitApp> data = topHitsApps.getData().stream().sorted(Comparator.comparingLong(TopHitsApps.TopHitApp::count).reversed()).filter(topHitApp -> applications.containsKey(topHitApp.id())).map(topHitApp -> TopHitsApps.TopHitApp.builder().id(topHitApp.id()).name(((BaseApplicationEntity)applications.get(topHitApp.id())).getName()).count(topHitApp.count()).build()).toList();
        return TopHitsApps.builder().data(data).build();
    }

    @Generated
    public SearchEnvironmentTopAppsByRequestCountUseCase(AnalyticsQueryService analyticsQueryService, ApiQueryService apiQueryService, ApplicationQueryService applicationQueryService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiQueryService = apiQueryService;
        this.applicationQueryService = applicationQueryService;
    }

    public record Input(ExecutionContext executionContext, AnalyticsQueryParameters parameters) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ExecutionContext executionContext;
            @Generated
            private AnalyticsQueryParameters parameters;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public InputBuilder parameters(AnalyticsQueryParameters parameters) {
                this.parameters = parameters;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.executionContext, this.parameters);
            }

            @Generated
            public String toString() {
                return "SearchEnvironmentTopAppsByRequestCountUseCase.Input.InputBuilder(executionContext=" + String.valueOf(this.executionContext) + ", parameters=" + String.valueOf(this.parameters) + ")";
            }
        }
    }

    public record Output(TopHitsApps topHitsApps) {
    }
}

