/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.analytics.domain_service.AnalyticsMetadataProvider;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@DomainService
public class PlanMetadataProvider
implements AnalyticsMetadataProvider {
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_UNKNOWN_PLAN_NAME = "Unknown plan (keyless)";
    private static final String METADATA_DELETED_PLAN_NAME = "Deleted plan";
    private static final String UNKNOWN_SERVICE = "1";
    private static final String UNKNOWN_SERVICE_MAPPED = "?";
    private final PlanCrudService planCrudService;
    private static final PlanMetadata UNKNOWN_PLAN = new PlanMetadata("Unknown plan (keyless)", true, false);
    private static final PlanMetadata NOT_FOUND = new PlanMetadata("Deleted plan", false, true);

    public PlanMetadataProvider(PlanCrudService planCrudService) {
        this.planCrudService = planCrudService;
    }

    @Override
    public boolean appliesTo(AnalyticsMetadataProvider.Field field) {
        return field == AnalyticsMetadataProvider.Field.PLAN;
    }

    @Override
    public Map<String, String> provide(String key, String environmentId) {
        return this.provide(List.of(key), environmentId).getOrDefault(key, Map.of());
    }

    private static PlanMetadata ofPlan(Plan plan) {
        return new PlanMetadata(plan.getName(), false, false);
    }

    @Override
    public Map<String, Map<String, String>> provide(List<String> keys, String environmentId) {
        HashMap metaMap = new HashMap();
        keys.stream().filter(key -> UNKNOWN_SERVICE.equals(key) || UNKNOWN_SERVICE_MAPPED.equals(key)).forEach(key -> metaMap.put(key, UNKNOWN_PLAN));
        List<String> planIds = keys.stream().filter(key -> !UNKNOWN_SERVICE.equals(key) && !UNKNOWN_SERVICE_MAPPED.equals(key)).toList();
        if (!planIds.isEmpty()) {
            Map plans = this.planCrudService.findByIds(planIds).stream().collect(Collectors.toMap(Plan::getId, Function.identity()));
            plans.forEach((id, plan) -> metaMap.put(id, PlanMetadataProvider.ofPlan(plan)));
            planIds.stream().filter(id -> !plans.containsKey(id)).forEach(id -> metaMap.put(id, NOT_FOUND));
        }
        return metaMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((PlanMetadata)entry.getValue()).toMap()));
    }

    record PlanMetadata(String name, boolean unknown, boolean deleted) {
        Map<String, String> toMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(PlanMetadataProvider.METADATA_NAME, this.name);
            if (this.unknown) {
                result.put(PlanMetadataProvider.METADATA_UNKNOWN, Boolean.TRUE.toString());
            }
            if (this.deleted) {
                result.put(PlanMetadataProvider.METADATA_DELETED, Boolean.TRUE.toString());
            }
            return result;
        }
    }
}

