/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.analytics.domain_service.AnalyticsMetadataProvider;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@DomainService
public class ApiMetadataProvider
implements AnalyticsMetadataProvider {
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_VERSION = "version";
    private static final String METADATA_UNKNOWN_API_NAME = "Unknown API (not found)";
    private static final String METADATA_DELETED_API_NAME = "Deleted API";
    private static final String UNKNOWN_SERVICE = "1";
    private static final String UNKNOWN_SERVICE_MAPPED = "?";
    private final ApiCrudService apiCrudService;
    private static final ApiMetadata UNKNOWN_API = new ApiMetadata("Unknown API (not found)", true, null, false);
    private static final ApiMetadata NOT_FOUND = new ApiMetadata("Deleted API", false, null, true);

    public ApiMetadataProvider(ApiCrudService apiCrudService) {
        this.apiCrudService = apiCrudService;
    }

    @Override
    public boolean appliesTo(AnalyticsMetadataProvider.Field field) {
        return field == AnalyticsMetadataProvider.Field.API;
    }

    @Override
    public Map<String, String> provide(String key, String environmentId) {
        return this.provide(List.of(key), environmentId).getOrDefault(key, Map.of());
    }

    private static ApiMetadata ofApi(Api api) {
        return new ApiMetadata(api.getName(), false, api.getVersion(), api.getApiLifecycleState() == Api.ApiLifecycleState.ARCHIVED);
    }

    @Override
    public Map<String, Map<String, String>> provide(List<String> keys, String environmentId) {
        HashMap metaMap = new HashMap();
        keys.stream().filter(key -> UNKNOWN_SERVICE.equals(key) || UNKNOWN_SERVICE_MAPPED.equals(key)).forEach(key -> metaMap.put(key, UNKNOWN_API));
        List<String> apiIds = keys.stream().filter(key -> !UNKNOWN_SERVICE.equals(key) && !UNKNOWN_SERVICE_MAPPED.equals(key)).toList();
        if (!apiIds.isEmpty()) {
            Map apis = this.apiCrudService.findByIds(apiIds).stream().collect(Collectors.toMap(Api::getId, Function.identity()));
            apis.forEach((id, api) -> metaMap.put(id, ApiMetadataProvider.ofApi(api)));
            apiIds.stream().filter(id -> !apis.containsKey(id)).forEach(id -> metaMap.put(id, NOT_FOUND));
        }
        return metaMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ApiMetadata)entry.getValue()).toMap()));
    }

    record ApiMetadata(String name, boolean unknown, String version, boolean deleted) {
        Map<String, String> toMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(ApiMetadataProvider.METADATA_NAME, this.name);
            if (this.unknown) {
                result.put(ApiMetadataProvider.METADATA_UNKNOWN, Boolean.TRUE.toString());
            }
            if (this.version != null) {
                result.put(ApiMetadataProvider.METADATA_VERSION, this.version);
            }
            if (this.deleted) {
                result.put(ApiMetadataProvider.METADATA_DELETED, Boolean.TRUE.toString());
            }
            return result;
        }
    }
}

