/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AddOrgIdNotificationConfigsUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddOrgIdNotificationConfigsUpgrader.class);
    private final EnvironmentRepository environmentRepository;
    private final ApiRepository apiRepository;
    private final ApplicationRepository applicationRepository;
    private final GenericNotificationConfigRepository genericNotificationConfigRepository;
    private final PortalNotificationConfigRepository portalNotificationConfigRepository;

    public AddOrgIdNotificationConfigsUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy ApiRepository apiRepository, @Lazy ApplicationRepository applicationRepository, @Lazy GenericNotificationConfigRepository genericNotificationConfigRepository, @Lazy PortalNotificationConfigRepository portalNotificationConfigRepository) {
        this.environmentRepository = environmentRepository;
        this.apiRepository = apiRepository;
        this.applicationRepository = applicationRepository;
        this.genericNotificationConfigRepository = genericNotificationConfigRepository;
        this.portalNotificationConfigRepository = portalNotificationConfigRepository;
    }

    private String getEnvironmentOrgId(String envId) throws TechnicalException {
        Optional environment = this.environmentRepository.findById((Object)envId);
        return environment.map(Environment::getOrganizationId).orElse(null);
    }

    private String getApiOrgId(String apiId) throws TechnicalException {
        Optional api = this.apiRepository.findById((Object)apiId);
        if (api.isPresent()) {
            String envId = ((Api)api.get()).getEnvironmentId();
            return this.getEnvironmentOrgId(envId);
        }
        return null;
    }

    private String getApplicationOrgId(String apiId) throws TechnicalException {
        Optional application = this.applicationRepository.findById((Object)apiId);
        if (application.isPresent()) {
            String envId = ((Application)application.get()).getEnvironmentId();
            return this.getEnvironmentOrgId(envId);
        }
        return null;
    }

    private String getOrgId(String refId, NotificationReferenceType referenceType) throws TechnicalException {
        if (referenceType == NotificationReferenceType.ENVIRONMENT || referenceType == NotificationReferenceType.PORTAL) {
            return this.getEnvironmentOrgId(refId);
        }
        if (referenceType == NotificationReferenceType.API) {
            return this.getApiOrgId(refId);
        }
        if (referenceType == NotificationReferenceType.APPLICATION) {
            return this.getApplicationOrgId(refId);
        }
        return null;
    }

    public boolean upgrade() {
        try {
            Set genericNotificationConfigs = this.genericNotificationConfigRepository.findAll();
            log.info("Migrating {} genericNotificationConfigs -> adding orgId value", (Object)genericNotificationConfigs.size());
            for (GenericNotificationConfig genericNotificationConfig : genericNotificationConfigs) {
                String orgId = this.getOrgId(genericNotificationConfig.getReferenceId(), genericNotificationConfig.getReferenceType());
                if (genericNotificationConfig.getReferenceType() == NotificationReferenceType.PORTAL) {
                    ArrayList hooks = new ArrayList(genericNotificationConfig.getHooks() != null ? genericNotificationConfig.getHooks() : List.of());
                    this.genericNotificationConfigRepository.delete(genericNotificationConfig.getId());
                    genericNotificationConfig.setReferenceType(NotificationReferenceType.ENVIRONMENT);
                    genericNotificationConfig.setOrganizationId(orgId);
                    genericNotificationConfig.setHooks(hooks);
                    this.genericNotificationConfigRepository.create(genericNotificationConfig);
                    continue;
                }
                genericNotificationConfig.setOrganizationId(orgId);
                this.genericNotificationConfigRepository.update(genericNotificationConfig);
            }
            Set portalNotificationConfigs = this.portalNotificationConfigRepository.findAll();
            log.info("Migrating {} portalNotificationConfigs -> adding orgId value", (Object)portalNotificationConfigs.size());
            for (PortalNotificationConfig portalNotificationConfig : portalNotificationConfigs) {
                String orgId = this.getOrgId(portalNotificationConfig.getReferenceId(), portalNotificationConfig.getReferenceType());
                if (portalNotificationConfig.getReferenceType() == NotificationReferenceType.PORTAL) {
                    ArrayList hooks = new ArrayList(portalNotificationConfig.getHooks() != null ? portalNotificationConfig.getHooks() : List.of());
                    HashSet groups = new HashSet(portalNotificationConfig.getGroups() != null ? portalNotificationConfig.getGroups() : Set.of());
                    this.portalNotificationConfigRepository.delete(portalNotificationConfig);
                    portalNotificationConfig.setReferenceType(NotificationReferenceType.ENVIRONMENT);
                    portalNotificationConfig.setOrganizationId(orgId);
                    portalNotificationConfig.setHooks(hooks);
                    portalNotificationConfig.setGroups(groups);
                    this.portalNotificationConfigRepository.create(portalNotificationConfig);
                    continue;
                }
                portalNotificationConfig.setOrganizationId(orgId);
                this.portalNotificationConfigRepository.update(portalNotificationConfig);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to apply {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    public int getOrder() {
        return 708;
    }
}

