/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.membership;

import io.gravitee.apim.core.membership.domain_service.MembershipDomainService;
import io.gravitee.apim.core.membership.model.TransferOwnership;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TransferOwnershipNotAllowedException;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MembershipDomainServiceLegacyWrapper
implements MembershipDomainService {
    private final MembershipService legacyService;
    private final RoleService roleService;
    private final MembershipService membershipService;

    @Override
    public Map<String, char[]> getUserMemberPermissions(ExecutionContext executionContext, MembershipReferenceType referenceType, String referenceId, String userId) {
        return this.legacyService.getUserMemberPermissions(executionContext, referenceType, referenceId, userId);
    }

    @Override
    public void transferOwnership(TransferOwnership transferOwnership, RoleScope roleScope, String itemId) {
        this.validateTransferOwnership(transferOwnership);
        ArrayList<RoleEntity> newRoles = new ArrayList<RoleEntity>();
        this.roleService.findByScopeAndName(roleScope, transferOwnership.getCurrentPrimaryOwnerNewRole(), GraviteeContext.getExecutionContext().getOrganizationId()).ifPresent(newRoles::add);
        MembershipService.MembershipMember membershipMember = new MembershipService.MembershipMember(transferOwnership.getNewPrimaryOwnerId(), transferOwnership.getUserReference(), MembershipMemberType.USER);
        this.legacyService.transferOwnership(GraviteeContext.getExecutionContext(), MembershipReferenceType.valueOf((String)roleScope.name()), roleScope, itemId, membershipMember, newRoles);
    }

    @Override
    public MemberEntity createNewMembership(ExecutionContext executionContext, io.gravitee.apim.core.member.model.MembershipReferenceType referenceType, String referenceId, String userId, String externalReference, String roleName) {
        return this.membershipService.createNewMembership(executionContext, MembershipReferenceType.valueOf((String)referenceType.name()), referenceId, userId, externalReference, roleName);
    }

    private void validateTransferOwnership(TransferOwnership transferOwnership) {
        if ("PRIMARY_OWNER".equals(transferOwnership.getCurrentPrimaryOwnerNewRole())) {
            throw new TransferOwnershipNotAllowedException(transferOwnership.getCurrentPrimaryOwnerNewRole());
        }
    }

    @Generated
    public MembershipDomainServiceLegacyWrapper(MembershipService legacyService, RoleService roleService, MembershipService membershipService) {
        this.legacyService = legacyService;
        this.roleService = roleService;
        this.membershipService = membershipService;
    }
}

