/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PageHRIDUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageHRIDUpgrader.class);
    @Lazy
    @Autowired
    private PageRepository pageRepository;

    public boolean upgrade() {
        try {
            this.pageRepository.findAll().forEach(page -> {
                page.setHrid(page.getId());
                try {
                    this.pageRepository.update(page);
                }
                catch (TechnicalException e) {
                    log.error("Unable to set HRID for Plan {}", (Object)page.getId(), (Object)e);
                    throw new RuntimeException(e);
                }
            });
            return true;
        }
        catch (TechnicalException e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
    }

    public int getOrder() {
        return 710;
    }
}

