/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApplicationHRIDUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationHRIDUpgrader.class);
    @Lazy
    @Autowired
    private ApplicationRepository applicationRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;

    public boolean upgrade() {
        try {
            for (Environment environment : this.environmentRepository.findAll()) {
                this.setHRIDs(new ExecutionContext(environment));
            }
            return true;
        }
        catch (TechnicalException e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
    }

    public int getOrder() {
        return 709;
    }

    private void setHRIDs(ExecutionContext executionContext) throws TechnicalException {
        this.applicationRepository.findAllByEnvironment(executionContext.getEnvironmentId(), new ApplicationStatus[0]).forEach(application -> {
            application.setHrid(application.getId());
            try {
                this.applicationRepository.update(application);
            }
            catch (TechnicalException e) {
                log.error("Unable to set HRID for Application {}", (Object)application.getId(), (Object)e);
                throw new RuntimeException(e);
            }
        });
    }
}

