/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.TenantRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Tenant;
import io.gravitee.rest.api.model.NewTenantEntity;
import io.gravitee.rest.api.model.TenantEntity;
import io.gravitee.rest.api.model.TenantReferenceType;
import io.gravitee.rest.api.model.UpdateTenantEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.TenantService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.DuplicateTenantNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TenantNotFoundException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TenantServiceImpl
extends TransactionalService
implements TenantService {
    private final Logger LOGGER = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Lazy
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public TenantEntity findByIdAndReference(String tenantId, String referenceId, TenantReferenceType tenantReferenceType) {
        try {
            this.LOGGER.debug("Find tenant by ID: {}", (Object)tenantId);
            Optional optTenant = this.tenantRepository.findByIdAndReference(tenantId, referenceId, this.repoTenantReferenceType(tenantReferenceType));
            if (!optTenant.isPresent()) {
                throw new TenantNotFoundException(tenantId);
            }
            return this.convert((Tenant)optTenant.get());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find tenant by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find tenant by ID", ex);
        }
    }

    @Override
    public List<TenantEntity> findByReference(String referenceId, TenantReferenceType referenceType) {
        try {
            this.LOGGER.debug("Find all tenants");
            return this.tenantRepository.findByReference(referenceId, this.repoTenantReferenceType(referenceType)).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all tenants", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all tenants", ex);
        }
    }

    @Override
    public List<TenantEntity> create(ExecutionContext executionContext, List<NewTenantEntity> tenantEntities, String referenceId, TenantReferenceType referenceType) {
        List tenantNames = tenantEntities.stream().map(NewTenantEntity::getName).collect(Collectors.toList());
        Optional<TenantEntity> optionalTenant = this.findByReference(referenceId, referenceType).stream().filter(tenant -> tenantNames.contains(tenant.getName())).findAny();
        if (optionalTenant.isPresent()) {
            throw new DuplicateTenantNameException(optionalTenant.get().getName());
        }
        ArrayList<TenantEntity> savedTenants = new ArrayList<TenantEntity>(tenantEntities.size());
        tenantEntities.forEach(tenantEntity -> {
            try {
                Tenant tenant = this.convert((NewTenantEntity)tenantEntity, referenceId, referenceType);
                savedTenants.add(this.convert((Tenant)this.tenantRepository.create((Object)tenant)));
                this.auditService.createAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.TENANT, tenant.getId())).event((Audit.AuditEvent)Tenant.AuditEvent.TENANT_CREATED).createdAt(new Date()).oldValue(null).newValue(tenant).build());
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to create tenant {}", (Object)tenantEntity.getName(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to create tenant " + tenantEntity.getName(), ex);
            }
        });
        return savedTenants;
    }

    @Override
    public List<TenantEntity> update(ExecutionContext executionContext, List<UpdateTenantEntity> tenantEntities, String referenceId, TenantReferenceType referenceType) {
        ArrayList<TenantEntity> savedTenants = new ArrayList<TenantEntity>(tenantEntities.size());
        tenantEntities.forEach(tenantEntity -> {
            try {
                Tenant tenant = this.convert((UpdateTenantEntity)tenantEntity);
                Optional tenantOptional = this.tenantRepository.findByIdAndReference(tenant.getId(), referenceId, this.repoTenantReferenceType(referenceType));
                if (tenantOptional.isPresent()) {
                    Tenant existingTenant = (Tenant)tenantOptional.get();
                    tenant.setReferenceId(existingTenant.getReferenceId());
                    tenant.setReferenceType(existingTenant.getReferenceType());
                    savedTenants.add(this.convert((Tenant)this.tenantRepository.update((Object)tenant)));
                    this.auditService.createAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.TENANT, tenant.getId())).event((Audit.AuditEvent)Tenant.AuditEvent.TENANT_UPDATED).createdAt(new Date()).oldValue(tenantOptional.get()).newValue(tenant).build());
                }
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to update tenant {}", (Object)tenantEntity.getName(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update tenant " + tenantEntity.getName(), ex);
            }
        });
        return savedTenants;
    }

    @Override
    public void delete(ExecutionContext executionContext, String tenantId, String referenceId, TenantReferenceType referenceType) {
        try {
            Optional tenantOptional = this.tenantRepository.findByIdAndReference(tenantId, referenceId, this.repoTenantReferenceType(referenceType));
            if (tenantOptional.isPresent()) {
                this.tenantRepository.delete((Object)tenantId);
                this.auditService.createAuditLog(executionContext, AuditService.AuditLogData.builder().properties(Collections.singletonMap(Audit.AuditProperties.TENANT, tenantId)).event((Audit.AuditEvent)Tenant.AuditEvent.TENANT_DELETED).createdAt(new Date()).oldValue(null).newValue(tenantOptional.get()).build());
                this.tenantRepository.delete((Object)tenantId);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete tenant {}", (Object)tenantId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete tenant " + tenantId, ex);
        }
    }

    private Tenant convert(NewTenantEntity tenantEntity, String referenceId, TenantReferenceType referenceType) {
        Tenant tenant = new Tenant();
        tenant.setId(IdGenerator.generate((String)tenantEntity.getName()));
        tenant.setName(tenantEntity.getName());
        tenant.setDescription(tenantEntity.getDescription());
        tenant.setReferenceId(referenceId);
        tenant.setReferenceType(io.gravitee.repository.management.model.TenantReferenceType.valueOf((String)referenceType.name()));
        return tenant;
    }

    private Tenant convert(UpdateTenantEntity tenantEntity) {
        Tenant tenant = new Tenant();
        tenant.setId(tenantEntity.getId());
        tenant.setName(tenantEntity.getName());
        tenant.setDescription(tenantEntity.getDescription());
        return tenant;
    }

    private TenantEntity convert(Tenant tenant) {
        TenantEntity tenantEntity = new TenantEntity();
        tenantEntity.setId(tenant.getId());
        tenantEntity.setName(tenant.getName());
        tenantEntity.setDescription(tenant.getDescription());
        return tenantEntity;
    }

    private io.gravitee.repository.management.model.TenantReferenceType repoTenantReferenceType(TenantReferenceType referenceType) {
        return io.gravitee.repository.management.model.TenantReferenceType.valueOf((String)referenceType.name());
    }
}

