/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.descriptor.GraviteeDescriptorEntity;
import io.gravitee.rest.api.service.GraviteeDescriptorService;
import io.gravitee.rest.api.service.exceptions.GraviteeDescriptorReadException;
import io.gravitee.rest.api.service.exceptions.GraviteeDescriptorVersionException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GraviteeDescriptorServiceImpl
extends TransactionalService
implements GraviteeDescriptorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraviteeDescriptorServiceImpl.class);
    private static final String DESCRIPTOR_FILENAME = ".gravitee.json";

    @Override
    public String descriptorName() {
        return DESCRIPTOR_FILENAME;
    }

    @Override
    public GraviteeDescriptorEntity read(String s) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            GraviteeDescriptorEntity descriptorEntity = (GraviteeDescriptorEntity)mapper.readValue(s, GraviteeDescriptorEntity.class);
            this.assertVersion(descriptorEntity);
            return descriptorEntity;
        }
        catch (IOException e) {
            log.error("An error occurs while trying to read the descriptor", (Throwable)e);
            throw new GraviteeDescriptorReadException("An error occurs while trying to read the descriptor");
        }
    }

    private void assertVersion(GraviteeDescriptorEntity descriptorEntity) {
        if (1 != descriptorEntity.getVersion()) {
            throw new GraviteeDescriptorVersionException(descriptorEntity.getVersion());
        }
    }
}

