/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.log.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.log.crud_service.ConnectionLogsCrudService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.analytics.SearchLogsFilters;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.v4.log.SearchLogsResponse;
import io.gravitee.rest.api.model.v4.log.connection.BaseConnectionLog;
import io.gravitee.rest.api.model.v4.log.connection.ConnectionLogModel;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Optional;

@UseCase
public class SearchApiV4ConnectionLogsUseCase {
    static final String UNKNOWN = "Unknown";
    private final ConnectionLogsCrudService connectionLogsCrudService;
    private final PlanCrudService planCrudService;
    private final ApplicationCrudService applicationCrudService;

    public SearchApiV4ConnectionLogsUseCase(ConnectionLogsCrudService connectionLogsCrudService, PlanCrudService planCrudService, ApplicationCrudService applicationCrudService) {
        this.connectionLogsCrudService = connectionLogsCrudService;
        this.planCrudService = planCrudService;
        this.applicationCrudService = applicationCrudService;
    }

    public Output execute(ExecutionContext executionContext, Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 20));
        SearchLogsResponse<BaseConnectionLog> response = this.connectionLogsCrudService.searchApiConnectionLogs(executionContext, input.apiId(), input.logsFilters(), pageable, List.of(DefinitionVersion.V4));
        return this.mapToResponse(executionContext, response);
    }

    private Output mapToResponse(ExecutionContext executionContext, SearchLogsResponse<BaseConnectionLog> logs) {
        long total = logs.total();
        List<ConnectionLogModel> data = logs.logs().stream().map(log -> this.mapToModel(executionContext, (BaseConnectionLog)log)).toList();
        return new Output(total, data);
    }

    private ConnectionLogModel mapToModel(ExecutionContext executionContext, BaseConnectionLog connectionLog) {
        return ((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)ConnectionLogModel.builder().apiId(connectionLog.getApiId())).requestId(connectionLog.getRequestId())).timestamp(connectionLog.getTimestamp())).application(this.getApplicationEntity(executionContext, connectionLog.getApplicationId())).clientIdentifier(connectionLog.getClientIdentifier() != null ? connectionLog.getClientIdentifier() : UNKNOWN)).method(connectionLog.getMethod())).plan(this.getPlanInfo(connectionLog.getPlanId())).requestEnded(connectionLog.isRequestEnded())).transactionId(connectionLog.getTransactionId())).status(connectionLog.getStatus())).gatewayResponseTime(connectionLog.getGatewayResponseTime())).uri(connectionLog.getUri())).endpoint(connectionLog.getEndpoint()).errorComponentType(connectionLog.getErrorComponentType())).errorComponentName(connectionLog.getErrorComponentName())).errorKey(connectionLog.getErrorKey())).message(connectionLog.getMessage())).warnings(connectionLog.getWarnings() != null ? connectionLog.getWarnings() : List.of())).build();
    }

    private GenericPlanEntity getPlanInfo(String planId) {
        BasePlanEntity unknownPlan = BasePlanEntity.builder().id(planId).name(UNKNOWN).build();
        try {
            return planId != null ? this.planCrudService.getById(planId) : unknownPlan;
        }
        catch (PlanNotFoundException | TechnicalManagementException e) {
            return unknownPlan;
        }
    }

    private BaseApplicationEntity getApplicationEntity(ExecutionContext executionContext, String applicationId) {
        try {
            return this.applicationCrudService.findById(applicationId, executionContext.getEnvironmentId());
        }
        catch (ApplicationNotFoundException | TechnicalManagementException e) {
            return BaseApplicationEntity.builder().id(applicationId).name(UNKNOWN).build();
        }
    }

    public record Input(String apiId, SearchLogsFilters logsFilters, Optional<Pageable> pageable) {
        public Input(String apiId, SearchLogsFilters logsFilters) {
            this(apiId, logsFilters, Optional.empty());
        }

        public Input(String apiId, SearchLogsFilters logsFilters, Pageable pageable) {
            this(apiId, logsFilters, Optional.of(pageable));
        }
    }

    public record Output(long total, List<ConnectionLogModel> data) {
    }
}

