/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.domain_service.AnalyticsMetadataProvider;
import io.gravitee.apim.core.analytics.domain_service.ApiAnalyticsSpecification;
import io.gravitee.apim.core.analytics.model.GroupByAnalytics;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchGroupByAnalyticsUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchGroupByAnalyticsUseCase.class);
    private final ApiCrudService apiCrudService;
    private final AnalyticsQueryService analyticsQueryService;
    private final List<AnalyticsMetadataProvider> metadataProviders;

    public Output execute(ExecutionContext executionContext, Input input) {
        ApiAnalyticsSpecification.forSearchGroupByAnalytics().throwIfNotSatisfied(this.apiCrudService.get(input.api()), executionContext, input.from(), input.to());
        AnalyticsQueryService.GroupByQuery groupByQuery = new AnalyticsQueryService.GroupByQuery(AnalyticsQueryService.SearchTermId.forApi(input.api()), Instant.ofEpochMilli(input.from()), Instant.ofEpochMilli(input.to()), input.field(), input.groups(), input.order(), input.query());
        GroupByAnalytics result = this.analyticsQueryService.searchGroupByAnalytics(executionContext, groupByQuery).orElse(null);
        if (result == null) {
            return new Output(null, null);
        }
        Optional<AnalyticsMetadataProvider> provider = this.metadataProviders.stream().filter(p -> p.appliesTo(AnalyticsMetadataProvider.Field.of(input.field()))).findFirst();
        if (provider.isEmpty()) {
            Map<String, Map<String, String>> metadata = Stream.iterate(0, i -> i + 1).limit(result.getOrder().size()).collect(Collectors.toMap(i -> result.getOrder().get((int)i), i -> {
                HashMap<String, String> itemMetadata = new HashMap<String, String>();
                itemMetadata.put("order", String.valueOf(i));
                return itemMetadata;
            }));
            return new Output(result, metadata);
        }
        Map<String, Map<String, String>> batchMetadata = provider.get().provide(result.getOrder(), executionContext.getEnvironmentId());
        Map<String, Map<String, String>> metadata = Stream.iterate(0, i -> i + 1).limit(result.getOrder().size()).collect(Collectors.toMap(i -> result.getOrder().get((int)i), i -> {
            String key = result.getOrder().get((int)i);
            HashMap<String, String> itemMetadata = new HashMap<String, String>(batchMetadata.getOrDefault(key, new HashMap()));
            itemMetadata.put("order", String.valueOf(i));
            return itemMetadata;
        }));
        return new Output(result, metadata);
    }

    @Generated
    public SearchGroupByAnalyticsUseCase(ApiCrudService apiCrudService, AnalyticsQueryService analyticsQueryService, List<AnalyticsMetadataProvider> metadataProviders) {
        this.apiCrudService = apiCrudService;
        this.analyticsQueryService = analyticsQueryService;
        this.metadataProviders = metadataProviders;
    }

    public record Input(String api, long from, long to, String field, List<AnalyticsQueryService.GroupByQuery.Group> groups, Optional<AnalyticsQueryService.GroupByQuery.Order> order, Optional<String> query) {
    }

    public record Output(GroupByAnalytics analytics, Map<String, Map<String, String>> metadata) {
    }
}

