/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PortalNotificationConfigRepository;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.PortalNotificationConfig;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.notification.NotificationConfigType;
import io.gravitee.rest.api.model.notification.PortalNotificationConfigEntity;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PortalNotificationConfigServiceImpl
extends AbstractService
implements PortalNotificationConfigService {
    private final Logger LOGGER = LoggerFactory.getLogger(PortalNotificationConfigServiceImpl.class);
    private final PortalNotificationConfigRepository portalNotificationConfigRepository;
    private final MembershipService membershipService;
    private final GroupService groupService;

    public PortalNotificationConfigServiceImpl(@Lazy PortalNotificationConfigRepository portalNotificationConfigRepository, MembershipService membershipService, GroupService groupService) {
        this.portalNotificationConfigRepository = portalNotificationConfigRepository;
        this.membershipService = membershipService;
        this.groupService = groupService;
    }

    @Override
    public PortalNotificationConfigEntity save(PortalNotificationConfigEntity notificationEntity) {
        try {
            if (notificationEntity.getHooks() == null || notificationEntity.getHooks().isEmpty()) {
                this.portalNotificationConfigRepository.delete(this.convert(notificationEntity));
                return PortalNotificationConfigEntity.newDefaultEmpty((String)notificationEntity.getUser(), (String)notificationEntity.getReferenceType(), (String)notificationEntity.getReferenceId(), (String)notificationEntity.getOrganizationId());
            }
            Optional optionalConfig = this.portalNotificationConfigRepository.findById(notificationEntity.getUser(), NotificationReferenceType.valueOf((String)notificationEntity.getReferenceType()), notificationEntity.getReferenceId());
            PortalNotificationConfig notificationConfig = this.convert(notificationEntity);
            if (optionalConfig.isPresent()) {
                notificationConfig.setUser(notificationConfig.getUser());
                notificationConfig.setCreatedAt(((PortalNotificationConfig)optionalConfig.get()).getCreatedAt());
                notificationConfig.setUpdatedAt(new Date());
                return this.convert(this.portalNotificationConfigRepository.update(notificationConfig));
            }
            notificationConfig.setUser(notificationConfig.getUser());
            notificationConfig.setCreatedAt(new Date());
            notificationConfig.setUpdatedAt(notificationConfig.getCreatedAt());
            return this.convert(this.portalNotificationConfigRepository.create(notificationConfig));
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to save the notification settings {}", (Object)notificationEntity, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to save the notification settings " + String.valueOf(notificationEntity), te);
        }
    }

    @Override
    public PortalNotificationConfigEntity findById(String user, NotificationReferenceType referenceType, String referenceId) {
        try {
            Optional optionalConfig = this.portalNotificationConfigRepository.findById(user, referenceType, referenceId);
            if (optionalConfig.isPresent()) {
                return this.convert((PortalNotificationConfig)optionalConfig.get());
            }
            PortalNotificationConfigEntity notif = PortalNotificationConfigEntity.newDefaultEmpty((String)user, (String)referenceType.name(), (String)referenceId, (String)GraviteeContext.getExecutionContext().getOrganizationId());
            notif.setGroupHooks(this.findGroupHooks(GraviteeContext.getExecutionContext(), user, referenceType, referenceId));
            return notif;
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to get the notification settings {}/{}/{}", new Object[]{user, referenceType, referenceId, te});
            throw new TechnicalManagementException("An error occurs while trying to get the notification settings " + user + "/" + String.valueOf(referenceType) + "/" + referenceId, te);
        }
    }

    @Override
    public void deleteByUser(String user) {
        try {
            this.portalNotificationConfigRepository.deleteByUser(user);
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to delete notification settings for user {}", (Object)user, (Object)te);
            throw new TechnicalManagementException("An error occurs while trying to delete notification settings for user " + user, te);
        }
    }

    @Override
    public void deleteReference(NotificationReferenceType referenceType, String referenceId) {
        try {
            this.portalNotificationConfigRepository.deleteByReferenceIdAndReferenceType(referenceId, referenceType);
        }
        catch (TechnicalException te) {
            this.LOGGER.error("An error occurs while trying to delete notification settings for reference {} / {}", new Object[]{referenceType, referenceId, te});
            throw new TechnicalManagementException("An error occurs while trying to delete notification settings for reference " + String.valueOf(referenceType) + " / " + referenceId, te);
        }
    }

    @Override
    public void removeGroupIds(String apiId, Set<String> groupIds) {
        ExecutionContext executionContext = GraviteeContext.getExecutionContext();
        String primaryOwnerUserId = this.membershipService.getPrimaryOwnerUserId(executionContext.getOrganizationId(), MembershipReferenceType.API, apiId);
        try {
            Optional notification = this.portalNotificationConfigRepository.findById(primaryOwnerUserId, NotificationReferenceType.API, apiId);
            if (notification.isPresent() && ((PortalNotificationConfig)notification.get()).getGroups() != null) {
                PortalNotificationConfig portalNotificationConfig = (PortalNotificationConfig)notification.get();
                portalNotificationConfig.getGroups().removeAll(groupIds);
                this.portalNotificationConfigRepository.update(portalNotificationConfig);
            }
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to get the notification settings " + primaryOwnerUserId + "/API/" + apiId, e);
        }
    }

    private PortalNotificationConfig convert(PortalNotificationConfigEntity entity) {
        return PortalNotificationConfig.builder().referenceType(NotificationReferenceType.valueOf((String)entity.getReferenceType())).referenceId(entity.getReferenceId()).user(entity.getUser()).hooks(entity.getHooks()).groups(Set.copyOf(entity.getGroups())).origin(entity.getOrigin()).organizationId(entity.getOrganizationId()).build();
    }

    private PortalNotificationConfigEntity convert(PortalNotificationConfig portalNotificationConfig) {
        PortalNotificationConfigEntity entity = new PortalNotificationConfigEntity();
        entity.setConfigType(NotificationConfigType.PORTAL);
        entity.setReferenceType(portalNotificationConfig.getReferenceType().name());
        entity.setReferenceId(portalNotificationConfig.getReferenceId());
        entity.setUser(portalNotificationConfig.getUser());
        entity.setHooks(portalNotificationConfig.getHooks());
        entity.setGroups(List.copyOf(portalNotificationConfig.getGroups()));
        entity.setOrigin(portalNotificationConfig.getOrigin());
        entity.setOrganizationId(portalNotificationConfig.getOrganizationId());
        entity.setGroupHooks(this.findGroupHooks(GraviteeContext.getExecutionContext(), portalNotificationConfig.getUser(), portalNotificationConfig.getReferenceType(), portalNotificationConfig.getReferenceId()));
        return entity;
    }

    private Set<String> findGroupHooks(ExecutionContext executionContext, String userId, NotificationReferenceType referenceType, String referenceId) {
        try {
            String primaryOwnerUserId = this.membershipService.getPrimaryOwnerUserId(executionContext.getOrganizationId(), MembershipReferenceType.API, referenceId);
            Optional poNotif = this.portalNotificationConfigRepository.findById(primaryOwnerUserId, referenceType, referenceId);
            Set poNotifGroups = poNotif.map(PortalNotificationConfig::getGroups).orElse(Set.of());
            if (poNotifGroups.isEmpty()) {
                return Set.of();
            }
            List poNotifHooks = poNotif.map(PortalNotificationConfig::getHooks).orElse(List.of());
            List<String> groupIds = this.groupService.findByUser(userId).stream().map(GroupEntity::getId).toList();
            boolean hasGroupHooks = groupIds.stream().anyMatch(poNotifGroups::contains);
            return hasGroupHooks ? new HashSet(poNotifHooks) : Set.of();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }
}

