/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.media;

import io.gravitee.apim.core.media.model.Media;
import io.gravitee.apim.core.media.query_service.MediaQueryService;
import io.gravitee.apim.infra.adapter.MediaAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MediaQueryServiceImpl
extends AbstractService
implements MediaQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MediaQueryServiceImpl.class);
    private final MediaRepository mediaRepository;

    public MediaQueryServiceImpl(@Lazy MediaRepository mediaRepository) {
        this.mediaRepository = mediaRepository;
    }

    @Override
    public List<Media> findAllByApiId(String apiId) {
        try {
            return MediaAdapter.INSTANCE.mapMedia(this.mediaRepository.findAllByApi(apiId));
        }
        catch (TechnicalException e) {
            log.error("An error as occurred trying to find medias for API " + apiId, (Throwable)e);
            throw new TechnicalManagementException("An error as occurred trying to find medias", e);
        }
    }
}

