/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.membership;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.infra.adapter.MembershipAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipReferenceType;
import java.util.Collection;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MembershipCrudServiceImpl
implements MembershipCrudService {
    private final MembershipRepository membershipRepository;

    public MembershipCrudServiceImpl(@Lazy MembershipRepository membershipRepository) {
        this.membershipRepository = membershipRepository;
    }

    @Override
    public io.gravitee.apim.core.membership.model.Membership create(io.gravitee.apim.core.membership.model.Membership membership) {
        try {
            Membership result = this.membershipRepository.create(MembershipAdapter.INSTANCE.toRepository(membership));
            return MembershipAdapter.INSTANCE.toEntity(result);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to create the membership: " + membership.getId(), e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.membershipRepository.delete(id);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to delete the membership: " + id, e);
        }
    }

    @Override
    public Collection<io.gravitee.apim.core.membership.model.Membership> findByApiId(String apiId) {
        try {
            return CollectionUtils.stream(this.membershipRepository.findByReferenceIdAndReferenceType(apiId, MembershipReferenceType.API)).map(MembershipAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("An error occurs while trying to create the membership: " + apiId, e);
        }
    }
}

