/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.member.model.crd.MemberCRD;
import io.gravitee.apim.infra.adapter.ApiCRDEntityAdapter;
import io.gravitee.rest.api.model.AccessControlEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiCRDEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApiCRDEntityAdapterImpl
implements ApiCRDEntityAdapter {
    @Override
    public MemberCRD map(ApiCRDEntity.Member member) {
        if (member == null) {
            return null;
        }
        MemberCRD memberCRD = new MemberCRD();
        memberCRD.setSource(member.getSource());
        memberCRD.setSourceId(member.getSourceId());
        memberCRD.setRole(member.getRole());
        return memberCRD;
    }

    @Override
    public ApiCRDEntity.Member map(MemberCRD crd) {
        if (crd == null) {
            return null;
        }
        ApiCRDEntity.Member member = new ApiCRDEntity.Member();
        member.setSource(crd.getSource());
        member.setSourceId(crd.getSourceId());
        member.setRole(crd.getRole());
        return member;
    }

    @Override
    public PageSourceEntity map(PageCRD.PageSource source) {
        if (source == null) {
            return null;
        }
        PageSourceEntity pageSourceEntity = new PageSourceEntity();
        pageSourceEntity.setType(source.getType());
        pageSourceEntity.setConfiguration(this.convertToJsonNode(source));
        return pageSourceEntity;
    }

    @Override
    public PageCRD.PageSource map(PageSourceEntity source) {
        if (source == null) {
            return null;
        }
        PageCRD.PageSource pageSource = new PageCRD.PageSource();
        pageSource.setType(source.getType());
        pageSource.setConfiguration(source.getConfiguration());
        pageSource.setConfigurationMap(this.deserializeSourceConfiguration(source));
        return pageSource;
    }

    @Override
    public PageCRD map(ApiCRDEntity.PageCRD crd) {
        if (crd == null) {
            return null;
        }
        PageCRD pageCRD = new PageCRD();
        pageCRD.setId(crd.getId());
        pageCRD.setHrid(crd.getHrid());
        pageCRD.setCrossId(crd.getCrossId());
        pageCRD.setName(crd.getName());
        if (crd.getType() != null) {
            pageCRD.setType(Enum.valueOf(PageCRD.Type.class, crd.getType()));
        }
        pageCRD.setOrder(crd.getOrder());
        pageCRD.setPublished(crd.isPublished());
        pageCRD.setVisibility(this.visibilityToVisibility(crd.getVisibility()));
        pageCRD.setParentId(crd.getParentId());
        pageCRD.setSource(this.map(crd.getSource()));
        Map map = crd.getConfiguration();
        if (map != null) {
            pageCRD.setConfiguration(new LinkedHashMap<String, String>(map));
        }
        pageCRD.setAccessControls(this.accessControlEntitySetToAccessControlSet(crd.getAccessControls()));
        pageCRD.setExcludedAccessControls(crd.isExcludedAccessControls());
        pageCRD.setContent(crd.getContent());
        pageCRD.setHomepage(crd.isHomepage());
        return pageCRD;
    }

    @Override
    public ApiCRDEntity.PageCRD map(PageCRD crd) {
        if (crd == null) {
            return null;
        }
        ApiCRDEntity.PageCRD pageCRD = new ApiCRDEntity.PageCRD();
        pageCRD.setId(crd.getId());
        pageCRD.setName(crd.getName());
        if (crd.getType() != null) {
            pageCRD.setType(crd.getType().name());
        }
        pageCRD.setContent(crd.getContent());
        pageCRD.setOrder(crd.getOrder());
        pageCRD.setPublished(crd.isPublished());
        pageCRD.setSource(this.map(crd.getSource()));
        Map<String, String> map = crd.getConfiguration();
        if (map != null) {
            pageCRD.setConfiguration(new LinkedHashMap<String, String>(map));
        }
        pageCRD.setHomepage(crd.isHomepage());
        pageCRD.setParentId(crd.getParentId());
        pageCRD.setVisibility(this.visibilityToVisibility1(crd.getVisibility()));
        pageCRD.setExcludedAccessControls(crd.isExcludedAccessControls());
        pageCRD.setAccessControls(this.accessControlSetToAccessControlEntitySet(crd.getAccessControls()));
        pageCRD.setCrossId(crd.getCrossId());
        pageCRD.setHrid(crd.getHrid());
        return pageCRD;
    }

    @Override
    public Set<MemberCRD> toMemberCRDs(List<ApiCRDEntity.Member> member) {
        if (member == null) {
            return null;
        }
        LinkedHashSet<MemberCRD> set = LinkedHashSet.newLinkedHashSet(member.size());
        for (ApiCRDEntity.Member member1 : member) {
            set.add(this.map(member1));
        }
        return set;
    }

    @Override
    public List<ApiCRDEntity.Member> toApiCRDMembers(Set<MemberCRD> crd) {
        if (crd == null) {
            return null;
        }
        ArrayList<ApiCRDEntity.Member> list = new ArrayList<ApiCRDEntity.Member>(crd.size());
        for (MemberCRD memberCRD : crd) {
            list.add(this.map(memberCRD));
        }
        return list;
    }

    @Override
    public Map<String, PageCRD> toCoreApiCRDPages(Map<String, ApiCRDEntity.PageCRD> crd) {
        if (crd == null) {
            return null;
        }
        LinkedHashMap<String, PageCRD> map = LinkedHashMap.newLinkedHashMap(crd.size());
        for (Map.Entry<String, ApiCRDEntity.PageCRD> entry : crd.entrySet()) {
            String key = entry.getKey();
            PageCRD value = this.map(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Map<String, ApiCRDEntity.PageCRD> toRestApiCRDPages(Map<String, PageCRD> crd) {
        if (crd == null) {
            return null;
        }
        LinkedHashMap<String, ApiCRDEntity.PageCRD> map = LinkedHashMap.newLinkedHashMap(crd.size());
        for (Map.Entry<String, PageCRD> entry : crd.entrySet()) {
            String key = entry.getKey();
            ApiCRDEntity.PageCRD value = this.map(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    protected PageCRD.Visibility visibilityToVisibility(Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Visibility.PUBLIC -> PageCRD.Visibility.PUBLIC;
            case Visibility.PRIVATE -> PageCRD.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(visibility));
        };
    }

    protected AccessControl accessControlEntityToAccessControl(AccessControlEntity accessControlEntity) {
        if (accessControlEntity == null) {
            return null;
        }
        AccessControl accessControl = new AccessControl();
        accessControl.setReferenceId(accessControlEntity.getReferenceId());
        accessControl.setReferenceType(accessControlEntity.getReferenceType());
        return accessControl;
    }

    protected Set<AccessControl> accessControlEntitySetToAccessControlSet(Set<AccessControlEntity> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<AccessControl> set1 = LinkedHashSet.newLinkedHashSet(set.size());
        for (AccessControlEntity accessControlEntity : set) {
            set1.add(this.accessControlEntityToAccessControl(accessControlEntity));
        }
        return set1;
    }

    protected Visibility visibilityToVisibility1(PageCRD.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case PageCRD.Visibility.PUBLIC -> Visibility.PUBLIC;
            case PageCRD.Visibility.PRIVATE -> Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)visibility));
        };
    }

    protected AccessControlEntity accessControlToAccessControlEntity(AccessControl accessControl) {
        if (accessControl == null) {
            return null;
        }
        AccessControlEntity accessControlEntity = new AccessControlEntity();
        accessControlEntity.setReferenceId(accessControl.getReferenceId());
        accessControlEntity.setReferenceType(accessControl.getReferenceType());
        return accessControlEntity;
    }

    protected Set<AccessControlEntity> accessControlSetToAccessControlEntitySet(Set<AccessControl> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<AccessControlEntity> set1 = LinkedHashSet.newLinkedHashSet(set.size());
        for (AccessControl accessControl : set) {
            set1.add(this.accessControlToAccessControlEntity(accessControl));
        }
        return set1;
    }
}

