/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case.members;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import lombok.Generated;

@UseCase
public class DeleteClusterMemberUseCase {
    private final MembershipCrudService membershipCrudService;
    private final MembershipQueryService membershipQueryService;

    public Output execute(Input input) {
        Membership membershipToDelete = this.membershipQueryService.findByReference(Membership.ReferenceType.CLUSTER, input.clusterId).stream().filter(membership -> membership.getMemberType().equals((Object)Membership.Type.USER)).filter(membership -> membership.getMemberId().equals(input.memberId)).findFirst().orElseThrow();
        this.membershipCrudService.delete(membershipToDelete.getId());
        return new Output();
    }

    @Generated
    public DeleteClusterMemberUseCase(MembershipCrudService membershipCrudService, MembershipQueryService membershipQueryService) {
        this.membershipCrudService = membershipCrudService;
        this.membershipQueryService = membershipQueryService;
    }

    public record Input(String clusterId, String memberId) {
    }

    public record Output() {
    }
}

