/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.cluster.use_case.members;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.model.AddMember;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.SinglePrimaryOwnerException;
import java.time.ZonedDateTime;
import lombok.Generated;

@UseCase
public class AddClusterMemberUseCase {
    private final MembershipCrudService membershipCrudService;
    private final RoleQueryService roleQueryService;

    public Output execute(Input input) {
        this.validateMembership(input.addMember);
        Role role = this.roleQueryService.findByScopeAndName(Role.Scope.CLUSTER, input.addMember.getRoleName(), input.audit.organizationId()).orElseThrow();
        ZonedDateTime now = TimeProvider.now();
        Membership membership = Membership.builder().id(UuidString.generateRandom()).referenceType(Membership.ReferenceType.CLUSTER).referenceId(input.clusterId).memberType(Membership.Type.USER).memberId(input.addMember.getUserId()).roleId(role.getId()).createdAt(now).updatedAt(now).build();
        this.membershipCrudService.create(membership);
        return new Output();
    }

    private void validateMembership(AddMember addMember) {
        if (SystemRole.PRIMARY_OWNER.name().equals(addMember.getRoleName())) {
            throw new SinglePrimaryOwnerException(RoleScope.CLUSTER);
        }
    }

    @Generated
    public AddClusterMemberUseCase(MembershipCrudService membershipCrudService, RoleQueryService roleQueryService) {
        this.membershipCrudService = membershipCrudService;
        this.roleQueryService = roleQueryService;
    }

    public record Input(AuditInfo audit, AddMember addMember, String clusterId) {
    }

    public record Output() {
    }
}

