/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model.utils;

import io.gravitee.apim.core.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class MigrationResult<T> {
    private static final Comparator<State> STATE_COMPARATOR = Comparator.comparing(State::getWeight);
    private final Collection<Issue> issues = new ArrayList<Issue>();
    private final T value;

    public MigrationResult(T value, Collection<Issue> issues) {
        this.value = value;
        this.issues.addAll(issues);
    }

    public static <T> Collector<MigrationResult<T>, CollectState<T>, MigrationResult<List<T>>> collectList() {
        return new Collector<MigrationResult<T>, CollectState<T>, MigrationResult<List<T>>>(){

            @Override
            public Supplier<CollectState<T>> supplier() {
                return () -> new CollectState(new ArrayList(), new ArrayList<Issue>());
            }

            @Override
            public BiConsumer<CollectState<T>, MigrationResult<T>> accumulator() {
                return (list, result) -> {
                    if (result.value != null) {
                        list.values.add(result.value);
                    }
                    list.issues.addAll(result.issues);
                };
            }

            @Override
            public BinaryOperator<CollectState<T>> combiner() {
                return (a, b) -> {
                    List issues = Stream.concat(a.issues.stream(), b.issues.stream()).toList();
                    List values = Stream.concat(a.values.stream(), b.values.stream()).toList();
                    return new CollectState(new ArrayList(values), new ArrayList<Issue>(issues));
                };
            }

            @Override
            public Function<CollectState<T>, MigrationResult<List<T>>> finisher() {
                return l -> new MigrationResult(l.values(), l.issues());
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of();
            }
        };
    }

    protected @Nullable T value() {
        return this.state() != State.IMPOSSIBLE ? (T)this.value : null;
    }

    public Collection<Issue> issues() {
        return List.copyOf(this.issues);
    }

    public State state() {
        return this.value == null ? State.IMPOSSIBLE : CollectionUtils.stream(this.issues).map(Issue::state).max(STATE_COMPARATOR).orElse(State.MIGRATABLE);
    }

    public MigrationResult<T> addIssue(Issue issue) {
        this.issues.add(issue);
        return this;
    }

    public MigrationResult<T> addIssue(String message, State state) {
        this.issues.add(new Issue(message, state));
        return this;
    }

    public MigrationResult<T> addIssues(Collection<Issue> issue) {
        this.issues.addAll(issue);
        return this;
    }

    public void processValue(Consumer<T> consumer) {
        T currentValue = this.value();
        if (currentValue != null) {
            consumer.accept(currentValue);
        }
    }

    public <U> MigrationResult<U> map(Function<T, U> mapper) {
        T newValue = null;
        Stream<Object> mappingIssue = Stream.empty();
        try {
            newValue = (T)mapper.apply(this.value);
        }
        catch (RuntimeException e) {
            mappingIssue = Stream.of(new Issue(e.getMessage(), State.IMPOSSIBLE));
        }
        return new MigrationResult<Object>(newValue, (Collection<Issue>)Stream.concat(mappingIssue, CollectionUtils.stream(this.issues)).toList());
    }

    public <U> MigrationResult<U> flatMap(Function<T, MigrationResult<U>> mapper) {
        return mapper.apply(this.value).addIssues(this.issues);
    }

    public <U> MigrationResult<T> foldLeft(MigrationResult<U> result, Merger<T, U> merger) {
        return new MigrationResult<T>(merger.merge(this.value(), result.value()), this.issues).addIssues(result.issues);
    }

    public static <T> MigrationResult<T> value(T value) {
        return new MigrationResult<T>(value, List.of());
    }

    public static <T> MigrationResult<T> issues(Collection<Issue> issues) {
        return new MigrationResult<Object>(null, issues);
    }

    public static <T> MigrationResult<T> issue(String message, State state) {
        return new MigrationResult<Object>(null, List.of(new Issue(message, state)));
    }

    public static enum State implements Comparable<State>
    {
        MIGRATABLE(0),
        MIGRATED(1),
        CAN_BE_FORCED(2),
        IMPOSSIBLE(3);

        private final int weight;

        @Generated
        private State(int weight) {
            this.weight = weight;
        }

        @Generated
        public int getWeight() {
            return this.weight;
        }
    }

    public record Issue(String message, State state) {
    }

    public static interface Merger<T, U>
    extends BiFunction<T, U, T> {
        public @Nullable T merge(@Nullable T var1, @Nullable U var2);

        @Override
        default public T apply(T result1, U result2) {
            return this.merge(result1, result2);
        }
    }

    public record CollectState<T>(ArrayList<T> values, ArrayList<Issue> issues) {
    }
}

