/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.common.data.domain.Page;
import io.gravitee.node.api.initializer.Initializer;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.service.PageRevisionService;
import io.gravitee.rest.api.service.PageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageRevisionInitializer
implements Initializer {
    private final Logger logger = LoggerFactory.getLogger(DefaultPageRevisionInitializer.class);
    @Autowired
    private PageService pageService;
    @Autowired
    private PageRevisionService pageRevisionService;

    public boolean initialize() {
        if (this.hasNoRevisions()) {
            this.logger.info("No page revisions found. Create a default revision based on pages.");
            int pageSize = 100;
            int pageNumber = 0;
            Page<PageEntity> pagesSubSet = null;
            do {
                PageableImpl pageable;
                if ((pagesSubSet = this.pageService.findAll((Pageable)(pageable = new PageableImpl(pageNumber, 100)))).getContent().isEmpty()) continue;
                pagesSubSet.getContent().stream().filter(entity -> this.pageService.shouldHaveRevision(entity.getType())).forEach(entity -> this.pageRevisionService.create(DefaultPageRevisionInitializer.convert(entity)));
                ++pageNumber;
            } while (!pagesSubSet.getContent().isEmpty());
        }
        return true;
    }

    private boolean hasNoRevisions() {
        io.gravitee.repository.management.api.search.Pageable pageable = new PageableBuilder().pageNumber(0).pageSize(1).build();
        return this.pageRevisionService.findAll(pageable).getContent().isEmpty();
    }

    private static io.gravitee.repository.management.model.Page convert(PageEntity pageEntity) {
        io.gravitee.repository.management.model.Page page = new io.gravitee.repository.management.model.Page();
        page.setId(pageEntity.getId());
        page.setName(pageEntity.getName());
        page.setType(pageEntity.getType());
        page.setContent(pageEntity.getContent());
        page.setLastContributor(pageEntity.getLastContributor());
        page.setCreatedAt(pageEntity.getLastModificationDate());
        page.setUpdatedAt(pageEntity.getLastModificationDate());
        return page;
    }

    public int getOrder() {
        return 200;
    }
}

