/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.domain_service.CheckContextExistsDomainService;
import io.gravitee.apim.core.portal_page.domain_service.PageExistsSpecification;
import io.gravitee.apim.core.portal_page.model.PortalPageWithViewDetails;
import io.gravitee.apim.core.portal_page.model.PortalViewContext;
import io.gravitee.apim.core.portal_page.query_service.PortalPageQueryService;
import lombok.Generated;

@UseCase
public class GetHomepageUseCase {
    private final CheckContextExistsDomainService checkContextExistsDomainService;
    private final PortalPageQueryService portalPageQueryService;

    public Output execute(Input input) {
        PageExistsSpecification<PortalViewContext> spec = PageExistsSpecification.byPortalViewContext(ctx -> this.checkContextExistsDomainService.portalViewContextExists(input.environmentId(), (PortalViewContext)((Object)ctx)));
        spec.throwIfNotSatisfied(PortalViewContext.HOMEPAGE);
        PortalPageWithViewDetails page = this.portalPageQueryService.findByEnvironmentIdAndContext(input.environmentId(), PortalViewContext.HOMEPAGE).getFirst();
        return new Output(page);
    }

    @Generated
    public GetHomepageUseCase(CheckContextExistsDomainService checkContextExistsDomainService, PortalPageQueryService portalPageQueryService) {
        this.checkContextExistsDomainService = checkContextExistsDomainService;
        this.portalPageQueryService = portalPageQueryService;
    }

    public record Input(String environmentId) {
    }

    public record Output(PortalPageWithViewDetails page) {
    }
}

